/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.StandardProtocolFamily;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javax.net.ssl.SSLContext;
import javax.swing.SwingUtilities;
import net.sf.eBus.config.AddressFilter;
import net.sf.eBus.config.ENetConfigure;
import net.sf.eBus.config.InetSocketAddressComparator;
import net.sf.eBus.config.ThreadType;

public final class EConfigure {
    public static final String CONFIG_FILE_ENV = "net.sf.eBus.config.file";
    public static final String JSON_FILE_ENV = "net.sf.eBus.config.jsonFile";
    public static final String EBUS_KEY = "eBus";
    public static final String NAME_KEY = "name";
    public static final String SERVICES_KEY = "services";
    public static final String SERVICE_PREFIX = "eBus.service.";
    public static final String CONNECTIONS_KEY = "connections";
    public static final String CONNECTION_PREFIX = "eBus.connection.";
    public static final String DISPATCHERS_KEY = "dispatchers";
    public static final String DISPATCHER_PREFIX = "dispatcher.";
    public static final String CONN_TYPE_KEY = "connectionType";
    public static final String PORT_KEY = "port";
    public static final String INBUFFER_SIZE_KEY = "inputBufferSize";
    public static final String OUTBUFFER_SIZE_KEY = "outputBufferSize";
    public static final String BYTE_ORDER_KEY = "byteOrder";
    public static final String MSG_QUEUE_SIZE_KEY = "messageQueueSize";
    public static final String SVC_SELECTOR_KEY = "serviceSelector";
    public static final String CONN_SELECTOR_KEY = "connectionSelector";
    public static final String SELECTOR_KEY = "selector";
    public static final String HOST_KEY = "host";
    public static final String BIND_PORT_KEY = "bindPort";
    public static final String RECONNECT_KEY = "reconnect";
    public static final String RECONNECT_DELAY_KEY = "reconnectTime";
    public static final String HB_DELAY_KEY = "heartbeatDelay";
    public static final String HB_REPLY_DELAY_KEY = "heartbeatReplyDelay";
    public static final String FILTER_KEY = "addressFilter";
    public static final String DEFAULT_KEY = "isDefault";
    public static final String DISPATCHER_TYPE_KEY = "dispatcherType";
    public static final String THREAD_TYPE_KEY = "runQueueType";
    public static final String SPIN_LIMIT_KEY = "spinLimit";
    public static final String PARK_TIME_KEY = "parkTime";
    public static final String PRIORITY_KEY = "priority";
    public static final String QUANTUM_KEY = "quantum";
    public static final String CLASSES_KEY = "classes";
    public static final String NUM_THREADS_KEY = "numberThreads";
    public static final String CAN_PAUSE_KEY = "canPause";
    public static final String PAUSE_KEY = "pause";
    public static final String PAUSE_DURATION_KEY = "pauseTime";
    public static final String MAX_BACKLOG_SIZE_KEY = "maxBacklogSize";
    public static final String DISCARD_POLICY_KEY = "discardPolicy";
    public static final String IDLE_TIME_KEY = "idleTime";
    public static final String MAX_CONNECT_TIME_KEY = "maxConnectTime";
    public static final String RESUME_ON_BACKLOG_SIZE_KEY = "resumeOnBacklogSize";
    private static final String SSL_CONTEXT_KEY = "sslContext";
    private static final char KEY_IFS = ',';
    private static final String KEY_SEP = ",";
    private static final String BIGENDIAN = "BIG_ENDIAN";
    private static final String LITTLEENDIAN = "LITTLE_ENDIAN";
    private static final ByteOrder DEFAULT_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final String DEFAULT_THREAD_TYPE = ThreadType.BLOCKING.textName();
    public static final int DEFAULT_SPIN_LIMIT = 2500000;
    public static final int DEFAULT_PARK_TIME = 1000;
    public static final int DEFAULT_PRIORITY = 5;
    public static final int DEFAULT_QUANTUM = 500000;
    public static final int DEFAULT_NUMBER_THREADS = 4;
    public static final int DEFAULT_QUEUE_SIZE = 0;
    public static final String DEFAULT_SELECTOR = ENetConfigure.defaultSelector().name();
    public static final boolean DEFAULT_RECONNECT_FLAG = false;
    public static final long DEFAULT_RECONNECT_TIME = 5000L;
    public static final long DEFAULT_HEARTBEAT_DELAY = 0L;
    public static final long DEFAULT_HEARTBEAT_REPLY_DELAY = 0L;
    private static final int NO_PORT = -2;
    private final Map<String, Service> mServices;
    private final Map<String, RemoteConnection> mRemoteConnections;
    private final Map<String, Dispatcher> mDispatchers;

    private EConfigure(Map<String, Service> services, Map<String, RemoteConnection> conns, Map<String, Dispatcher> dispatchers) {
        this.mServices = services;
        this.mRemoteConnections = conns;
        this.mDispatchers = dispatchers;
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof EConfigure) {
            EConfigure config = (EConfigure)o;
            retcode = this.mServices.equals(config.mServices) && this.mRemoteConnections.equals(config.mRemoteConnections) && this.mDispatchers.equals(config.mDispatchers);
        }
        return retcode;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        Formatter retval = new Formatter();
        retval.format("         services:", new Object[0]);
        if (this.mServices.isEmpty()) {
            retval.format("none%n", new Object[0]);
        } else {
            this.mServices.values().stream().forEach(service -> retval.format("%n    %s%n", service));
        }
        retval.format("       connections:", new Object[0]);
        if (this.mRemoteConnections.isEmpty()) {
            retval.format(" none%n", new Object[0]);
        } else {
            this.mRemoteConnections.values().stream().forEach(conn -> retval.format("%n    %s", conn));
        }
        return retval.toString();
    }

    public boolean hasServices() {
        return !this.mServices.isEmpty();
    }

    public boolean hasService(String name) {
        return this.mServices.containsKey(name);
    }

    public Map<String, Service> services() {
        return this.mServices;
    }

    public Service service(String name) {
        return this.mServices.get(name);
    }

    public boolean hasRemoteConnections() {
        return !this.mRemoteConnections.isEmpty();
    }

    public boolean hasRemoteConnection(String name) {
        return this.mRemoteConnections.containsKey(name);
    }

    public Map<String, RemoteConnection> remoteConnections() {
        return this.mRemoteConnections;
    }

    public RemoteConnection connection(String name) {
        return this.mRemoteConnections.get(name);
    }

    public Map<String, Dispatcher> dispatchers() {
        return this.mDispatchers;
    }

    public static EConfigure create(Map<String, Service> services, Map<String, RemoteConnection> connections, Map<String, Dispatcher> dispatchers) {
        return new EConfigure(services, connections, dispatchers);
    }

    public static ServerBuilder serverBuilder() {
        return new ServerBuilder();
    }

    public static ConnectionBuilder connectionBuilder() {
        return new ConnectionBuilder();
    }

    public static DispatcherBuilder dispatcherBuilder() {
        return new DispatcherBuilder();
    }

    public static PauseBuilder pauseBuilder(ConnectionRole role) {
        return new PauseBuilder(role);
    }

    public static EConfigure load(Properties props) {
        return new EConfigure(EConfigure.loadServices(props), EConfigure.loadConnections(props), EConfigure.loadDispatchers(props));
    }

    public static Map<String, Service> loadServices(Properties props) {
        net.sf.eBus.util.Properties p = EConfigure.properties(props);
        String[] names = p.getArrayProperty("eBus.services", ',');
        HashMap<String, Service> retval = new HashMap<String, Service>();
        for (String name : names) {
            String keyPrefix = SERVICE_PREFIX + name + ".";
            ServerBuilder builder = new ServerBuilder();
            builder.name(name);
            String key = keyPrefix + CONN_TYPE_KEY;
            builder.connectionType(EConfigure.getConnectionType(key, ConnectionType.TCP, p));
            key = keyPrefix + PORT_KEY;
            builder.port(EConfigure.getPort(key, -2, p));
            key = keyPrefix + FILTER_KEY;
            builder.addressFilter(EConfigure.getFilter(key, p));
            key = keyPrefix + INBUFFER_SIZE_KEY;
            builder.inputBufferSize(EConfigure.getSize(key, 2048, 0, p));
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            builder.outputBufferSize(EConfigure.getSize(key, 2048, 0, p));
            key = keyPrefix + BYTE_ORDER_KEY;
            builder.byteOrder(EConfigure.getByteOrder(key, DEFAULT_BYTE_ORDER, p));
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            builder.messageQueueSize(EConfigure.getSize(key, 0, 0, p));
            key = keyPrefix + SVC_SELECTOR_KEY;
            builder.serviceSelector(p.getProperty(key, DEFAULT_SELECTOR));
            key = keyPrefix + CONN_SELECTOR_KEY;
            builder.connectionSelector(p.getProperty(key, DEFAULT_SELECTOR));
            key = keyPrefix + HB_DELAY_KEY;
            builder.heartbeatDelay(p.getIntProperty(key, 0));
            key = keyPrefix + HB_REPLY_DELAY_KEY;
            builder.heartbeatReplyDelay(p.getIntProperty(key, 0));
            key = keyPrefix + CAN_PAUSE_KEY;
            builder.canPause(p.getBooleanProperty(key, false));
            if (builder.mCanPause) {
                PauseBuilder pauseBuilder = new PauseBuilder(ConnectionRole.ACCEPTOR);
                keyPrefix = keyPrefix + PAUSE_KEY + ".";
                key = keyPrefix + PAUSE_DURATION_KEY;
                pauseBuilder.duration(Duration.ofMillis(p.getIntProperty(key)));
                key = keyPrefix + MAX_BACKLOG_SIZE_KEY;
                pauseBuilder.maxBacklogSize(p.getIntProperty(key));
                builder.pauseConfig(pauseBuilder.build());
            }
            retval.put(name, builder.build());
        }
        return retval;
    }

    public static Map<String, RemoteConnection> loadConnections(Properties props) {
        net.sf.eBus.util.Properties p = EConfigure.properties(props);
        String[] names = p.getArrayProperty("eBus.connections", ',');
        HashMap<String, RemoteConnection> retval = new HashMap<String, RemoteConnection>();
        for (String name : names) {
            String keyPrefix = CONNECTION_PREFIX + name + ".";
            ConnectionBuilder builder = new ConnectionBuilder();
            ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)builder.name(name)).connectionType(EConfigure.getConnectionType(keyPrefix + CONN_TYPE_KEY, ConnectionType.TCP, p))).address(EConfigure.getAddress(name, keyPrefix, p)).bindPort(EConfigure.getPort(keyPrefix + BIND_PORT_KEY, 0, p)).inputBufferSize(EConfigure.getSize(keyPrefix + INBUFFER_SIZE_KEY, 2048, 0, p))).outputBufferSize(EConfigure.getSize(keyPrefix + OUTBUFFER_SIZE_KEY, 2048, 0, p))).byteOrder(EConfigure.getByteOrder(keyPrefix + BYTE_ORDER_KEY, DEFAULT_BYTE_ORDER, p))).messageQueueSize(EConfigure.getSize(keyPrefix + MSG_QUEUE_SIZE_KEY, 0, 0, p))).selector(p.getProperty(keyPrefix + SELECTOR_KEY, DEFAULT_SELECTOR));
            String key = keyPrefix + RECONNECT_KEY;
            builder.reconnect(p.getBooleanProperty(key, false));
            if (!builder.mReconnectFlag) {
                builder.reconnectDelay(0L);
            } else {
                key = keyPrefix + RECONNECT_DELAY_KEY;
                builder.reconnectDelay(EConfigure.getDelay(key, 5000, 0L, p));
            }
            ((ConnectionBuilder)builder.heartbeatDelay(p.getIntProperty(keyPrefix + HB_DELAY_KEY, 0))).heartbeatReplyDelay(p.getIntProperty(keyPrefix + HB_REPLY_DELAY_KEY, 0));
            key = keyPrefix + CAN_PAUSE_KEY;
            builder.canPause(p.getBooleanProperty(key, false));
            if (builder.mCanPause) {
                PauseBuilder pauseBuilder = new PauseBuilder(ConnectionRole.INITIATOR);
                keyPrefix = keyPrefix + PAUSE_KEY + ".";
                key = keyPrefix + PAUSE_DURATION_KEY;
                pauseBuilder.duration(Duration.ofMillis(p.getIntProperty(key)));
                key = keyPrefix + MAX_BACKLOG_SIZE_KEY;
                pauseBuilder.maxBacklogSize(p.getIntProperty(key));
                key = keyPrefix + DISCARD_POLICY_KEY;
                pauseBuilder.discardPolicy(DiscardPolicy.valueOf(p.getProperty(key, DiscardPolicy.OLDEST_FIRST.name())));
                key = keyPrefix + IDLE_TIME_KEY;
                pauseBuilder.idleTime(Duration.ofMillis(p.getIntProperty(key, 0)));
                key = keyPrefix + MAX_CONNECT_TIME_KEY;
                pauseBuilder.maxConnectionTime(Duration.ofMillis(p.getIntProperty(key)));
                key = keyPrefix + RESUME_ON_BACKLOG_SIZE_KEY;
                pauseBuilder.resumeOnBacklogSize(p.getIntProperty(key, 0));
                builder.pauseConfig(pauseBuilder.build());
            }
            retval.put(name, builder.build());
        }
        return retval;
    }

    public static Map<String, Dispatcher> loadDispatchers(Properties props) {
        net.sf.eBus.util.Properties p = EConfigure.properties(props);
        String key = "eBus.dispatchers";
        String[] names = p.getArrayProperty("eBus.dispatchers", ',');
        HashMap<String, Dispatcher> retval = new HashMap<String, Dispatcher>();
        for (String name : names) {
            DispatcherBuilder builder = new DispatcherBuilder();
            builder.name(name);
            builder.dispatcherType(DispatcherType.findType(name));
            if (builder.mType.isSpecial()) {
                EConfigure.loadSpecialDispatcher(builder, p);
            } else {
                EConfigure.loadDispatcher(builder, p);
            }
            retval.put(name, builder.build());
        }
        return retval;
    }

    @Deprecated
    public static EConfigure load(Preferences prefs) {
        return new EConfigure(EConfigure.loadServices(prefs), EConfigure.loadConnections(prefs), EConfigure.loadDispatchers(prefs));
    }

    @Deprecated
    public static Map<String, Service> loadServices(Preferences p) {
        String[] names = p.get("eBus.services", "").split(KEY_SEP);
        HashMap<String, Service> retval = new HashMap<String, Service>();
        for (String name : names) {
            String keyPrefix = SERVICE_PREFIX + name + ".";
            ServerBuilder builder = new ServerBuilder();
            builder.name(name);
            String key = keyPrefix + CONN_TYPE_KEY;
            builder.connectionType(EConfigure.getConnectionType(key, ConnectionType.TCP, p));
            key = keyPrefix + PORT_KEY;
            builder.port(EConfigure.getPort(key, 0, p));
            key = keyPrefix + FILTER_KEY;
            builder.addressFilter(EConfigure.getFilter(key, p));
            key = keyPrefix + INBUFFER_SIZE_KEY;
            builder.inputBufferSize(EConfigure.getSize(key, 2048, 0, p));
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            builder.outputBufferSize(EConfigure.getSize(key, 2048, 0, p));
            key = keyPrefix + BYTE_ORDER_KEY;
            builder.byteOrder(EConfigure.getByteOrder(key, DEFAULT_BYTE_ORDER, p));
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            builder.messageQueueSize(EConfigure.getSize(key, 0, 0, p));
            key = keyPrefix + SVC_SELECTOR_KEY;
            builder.serviceSelector(p.get(key, ENetConfigure.defaultSelector().name()));
            key = keyPrefix + SELECTOR_KEY;
            builder.connectionSelector(p.get(key, ENetConfigure.defaultSelector().name()));
            key = keyPrefix + HB_DELAY_KEY;
            builder.heartbeatDelay(p.getLong(key, 0L));
            key = keyPrefix + HB_REPLY_DELAY_KEY;
            builder.heartbeatReplyDelay(p.getLong(key, 0L));
            retval.put(name, builder.build());
        }
        return retval;
    }

    @Deprecated
    public static Map<String, RemoteConnection> loadConnections(Preferences p) {
        String[] names = p.get("eBus.connections", "").split(KEY_SEP);
        HashMap<String, RemoteConnection> retval = new HashMap<String, RemoteConnection>();
        for (String name : names) {
            String keyPrefix = CONNECTION_PREFIX + name + ".";
            ConnectionBuilder builder = new ConnectionBuilder();
            builder.name(name);
            String key = keyPrefix + CONN_TYPE_KEY;
            ((ConnectionBuilder)builder.connectionType(EConfigure.getConnectionType(key, ConnectionType.TCP, p))).address(EConfigure.getAddress(keyPrefix, p));
            key = keyPrefix + BIND_PORT_KEY;
            builder.bindPort(EConfigure.getPort(key, 0, p));
            builder.inputBufferSize(EConfigure.getSize(keyPrefix + INBUFFER_SIZE_KEY, 2048, 0, p));
            builder.outputBufferSize(EConfigure.getSize(keyPrefix + OUTBUFFER_SIZE_KEY, 2048, 0, p));
            builder.byteOrder(EConfigure.getByteOrder(keyPrefix + BYTE_ORDER_KEY, DEFAULT_BYTE_ORDER, p));
            builder.messageQueueSize(EConfigure.getSize(keyPrefix + MSG_QUEUE_SIZE_KEY, 0, 0, p));
            builder.selector(p.get(keyPrefix + SELECTOR_KEY, ENetConfigure.defaultSelector().name()));
            key = keyPrefix + RECONNECT_KEY;
            builder.reconnect(p.getBoolean(key, false));
            if (!builder.mReconnectFlag) {
                builder.reconnectDelay(0L);
            } else {
                key = keyPrefix + RECONNECT_DELAY_KEY;
                builder.reconnectDelay(EConfigure.getDelay(key, 5000, 0L, p));
            }
            key = keyPrefix + HB_DELAY_KEY;
            builder.heartbeatDelay(p.getLong(key, 0L));
            key = keyPrefix + HB_REPLY_DELAY_KEY;
            builder.heartbeatReplyDelay(p.getLong(key, 0L));
            retval.put(name, builder.build());
        }
        return retval;
    }

    @Deprecated
    public static Map<String, Dispatcher> loadDispatchers(Preferences p) {
        String key = "eBus.dispatchers";
        String[] names = p.get("eBus.dispatchers", "").split(KEY_SEP);
        HashMap<String, Dispatcher> retval = new HashMap<String, Dispatcher>();
        for (String name : names) {
            DispatcherBuilder builder = new DispatcherBuilder();
            builder.name(name);
            builder.dispatcherType(DispatcherType.findType(name));
            if (builder.mType.isSpecial()) {
                EConfigure.loadSpecialDispatcher(builder, p);
            } else {
                EConfigure.loadDispatcher(builder, p);
            }
            retval.put(name, builder.build());
        }
        return retval;
    }

    public static EConfigure load(Config config) {
        return new EConfigure(EConfigure.loadServices(config), EConfigure.loadConnections(config), EConfigure.loadDispatchers(config));
    }

    public static Map<String, Service> loadServices(Config config) {
        HashMap<String, Service> retval = new HashMap<String, Service>();
        if (config.hasPath(SERVICES_KEY)) {
            for (ConfigObject co : config.getObjectList(SERVICES_KEY)) {
                Service service = EConfigure.loadService(co.toConfig());
                retval.put(service.name(), service);
            }
        }
        return retval;
    }

    public static Map<String, RemoteConnection> loadConnections(Config config) {
        HashMap<String, RemoteConnection> retval = new HashMap<String, RemoteConnection>();
        if (config.hasPath(CONNECTIONS_KEY)) {
            for (ConfigObject co : config.getObjectList(CONNECTIONS_KEY)) {
                RemoteConnection connection = EConfigure.loadConnection(co.toConfig());
                retval.put(connection.name(), connection);
            }
        }
        return retval;
    }

    public static Map<String, Dispatcher> loadDispatchers(Config config) {
        HashMap<String, Dispatcher> retval = new HashMap<String, Dispatcher>();
        if (config.hasPath(DISPATCHERS_KEY)) {
            for (ConfigObject co : config.getObjectList(DISPATCHERS_KEY)) {
                Dispatcher dispatcher = EConfigure.loadDispatcher(co.toConfig());
                retval.put(dispatcher.name(), dispatcher);
            }
        }
        return retval;
    }

    public void store(Properties props) {
        this.storeService(props);
        this.storeConnections(props);
        this.storeDispatchers(props);
    }

    @Deprecated
    public void store(Preferences prefs) {
        this.storeService(prefs);
        this.storeConnections(prefs);
        this.storeDispatchers(prefs);
    }

    private static net.sf.eBus.util.Properties properties(Properties props) {
        net.sf.eBus.util.Properties retval = props instanceof net.sf.eBus.util.Properties ? (net.sf.eBus.util.Properties)props : new net.sf.eBus.util.Properties(props);
        return retval;
    }

    private static void loadDispatcher(DispatcherBuilder builder, net.sf.eBus.util.Properties p) {
        String keyName = "eBus.dispatcher." + builder.mName + ".";
        String key = keyName + THREAD_TYPE_KEY;
        builder.threadType(ThreadType.find(p.getProperty(key, DEFAULT_THREAD_TYPE)));
        if (builder.mRunQueueType == ThreadType.SPINPARK || builder.mRunQueueType == ThreadType.SPINYIELD) {
            key = keyName + SPIN_LIMIT_KEY;
            builder.spinLimit(p.getIntProperty(key, 2500000));
        }
        if (builder.mRunQueueType == ThreadType.SPINPARK) {
            key = keyName + PARK_TIME_KEY;
            builder.parkTime(p.getIntProperty(key, 1000));
        }
        key = keyName + PRIORITY_KEY;
        builder.priority(p.getIntProperty(key, 5));
        key = keyName + QUANTUM_KEY;
        builder.quantum(p.getIntProperty(key, 500000));
        key = keyName + NUM_THREADS_KEY;
        builder.numberThreads(p.getIntProperty(key, 4));
        key = keyName + DEFAULT_KEY;
        builder.isDefault(p.getBooleanProperty(key, false));
        if (builder.mIsDefault) {
            builder.classes(new Class[0]);
        } else {
            key = keyName + CLASSES_KEY;
            builder.classes(EConfigure.getClasses(key, p));
        }
    }

    private static void loadSpecialDispatcher(DispatcherBuilder builder, net.sf.eBus.util.Properties p) {
        String keyName = "eBus.dispatcher." + builder.mName + ".";
        String key = keyName + DEFAULT_KEY;
        builder.isDefault(p.getBooleanProperty(key, false));
        if (builder.mIsDefault) {
            builder.classes(new Class[0]);
        } else {
            key = keyName + CLASSES_KEY;
            builder.classes(EConfigure.getClasses(key, p));
        }
        builder.threadType(ThreadType.BLOCKING).spinLimit(0L).parkTime(0L).priority(0).quantum(0L).numberThreads(0);
    }

    private static void loadDispatcher(DispatcherBuilder builder, Preferences p) {
        String keyName = "eBus.dispatcher." + builder.mName + ".";
        String key = keyName + THREAD_TYPE_KEY;
        builder.threadType(ThreadType.find(p.get(key, DEFAULT_THREAD_TYPE)));
        if (builder.mRunQueueType == ThreadType.SPINPARK || builder.mRunQueueType == ThreadType.SPINYIELD) {
            key = keyName + SPIN_LIMIT_KEY;
            builder.spinLimit(p.getInt(key, 2500000));
        }
        if (builder.mRunQueueType == ThreadType.SPINPARK) {
            key = keyName + PARK_TIME_KEY;
            builder.parkTime(p.getInt(key, 1000));
        }
        key = keyName + PRIORITY_KEY;
        builder.priority(p.getInt(key, 5));
        key = keyName + QUANTUM_KEY;
        builder.quantum(p.getInt(key, 500000));
        key = keyName + NUM_THREADS_KEY;
        builder.numberThreads(p.getInt(key, 4));
        key = keyName + DEFAULT_KEY;
        builder.isDefault(p.getBoolean(key, false));
        if (builder.mIsDefault) {
            builder.classes(new Class[0]);
        } else {
            builder.classes(EConfigure.getClasses(key, p));
        }
    }

    private static void loadSpecialDispatcher(DispatcherBuilder builder, Preferences p) {
        String keyName = "eBus.dispatcher." + builder.mName + ".";
        String key = keyName + DEFAULT_KEY;
        builder.isDefault(p.getBoolean(key, false));
        if (builder.mIsDefault) {
            builder.classes(new Class[0]);
        } else {
            builder.classes(EConfigure.getClasses(key, p));
        }
        builder.threadType(ThreadType.BLOCKING).spinLimit(0L).parkTime(0L).priority(0).quantum(0L).numberThreads(0);
    }

    private static Service loadService(Config config) throws ConfigException {
        ConnectionType connType = config.hasPath(CONN_TYPE_KEY) ? (ConnectionType)config.getEnum(ConnectionType.class, CONN_TYPE_KEY) : ConnectionType.TCP;
        ServerBuilder builder = new ServerBuilder();
        ((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)builder.loaderFlag(true)).name(config.getString(NAME_KEY))).connectionType(connType)).port(config.getInt(PORT_KEY)).addressFilter(AddressFilter.load(config, FILTER_KEY)).inputBufferSize(config.hasPath(INBUFFER_SIZE_KEY) ? config.getInt(INBUFFER_SIZE_KEY) : 2048)).outputBufferSize(config.hasPath(OUTBUFFER_SIZE_KEY) ? config.getInt(OUTBUFFER_SIZE_KEY) : 2048)).byteOrder(EConfigure.loadByteOrder(config, BYTE_ORDER_KEY))).messageQueueSize(config.hasPath(MSG_QUEUE_SIZE_KEY) ? config.getInt(MSG_QUEUE_SIZE_KEY) : 0)).serviceSelector(config.hasPath(SVC_SELECTOR_KEY) ? config.getString(SVC_SELECTOR_KEY) : ENetConfigure.defaultSelector().name()).connectionSelector(config.hasPath(CONN_SELECTOR_KEY) ? config.getString(CONN_SELECTOR_KEY) : ENetConfigure.defaultSelector().name()).heartbeatDelay(config.hasPath(HB_DELAY_KEY) ? config.getLong(HB_DELAY_KEY) : 0L)).heartbeatReplyDelay(config.hasPath(HB_REPLY_DELAY_KEY) ? config.getLong(HB_REPLY_DELAY_KEY) : 0L)).canPause(config.hasPath(CAN_PAUSE_KEY) ? config.getBoolean(CAN_PAUSE_KEY) : false);
        if (builder.mCanPause) {
            Config pauseConfig = config.getConfig(PAUSE_KEY);
            PauseBuilder pauseBuilder = new PauseBuilder(ConnectionRole.ACCEPTOR);
            pauseBuilder.duration(pauseConfig.getDuration(PAUSE_DURATION_KEY)).maxBacklogSize(pauseConfig.getInt(MAX_BACKLOG_SIZE_KEY));
            builder.pauseConfig(pauseBuilder.build());
        }
        return builder.build();
    }

    private static RemoteConnection loadConnection(Config config) throws ConfigException {
        ConnectionType connType = config.hasPath(CONN_TYPE_KEY) ? (ConnectionType)config.getEnum(ConnectionType.class, CONN_TYPE_KEY) : ConnectionType.TCP;
        ConnectionBuilder builder = new ConnectionBuilder();
        ((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)((ConnectionBuilder)builder.loaderFlag(true)).name(config.getString(NAME_KEY))).connectionType(connType)).address(EConfigure.loadAddress(config)).bindPort(config.hasPath(BIND_PORT_KEY) ? config.getInt(BIND_PORT_KEY) : 0).inputBufferSize(config.hasPath(INBUFFER_SIZE_KEY) ? config.getInt(INBUFFER_SIZE_KEY) : 2048)).outputBufferSize(config.hasPath(OUTBUFFER_SIZE_KEY) ? config.getInt(OUTBUFFER_SIZE_KEY) : 2048)).byteOrder(EConfigure.loadByteOrder(config, BYTE_ORDER_KEY))).messageQueueSize(config.hasPath(MSG_QUEUE_SIZE_KEY) ? config.getInt(MSG_QUEUE_SIZE_KEY) : 0)).selector(config.hasPath(SELECTOR_KEY) ? config.getString(SELECTOR_KEY) : DEFAULT_SELECTOR).reconnect(config.hasPath(RECONNECT_KEY) ? config.getBoolean(RECONNECT_KEY) : false).reconnectDelay(builder.mReconnectFlag ? config.getLong(RECONNECT_DELAY_KEY) : 0L).heartbeatDelay(config.hasPath(HB_DELAY_KEY) ? config.getLong(HB_DELAY_KEY) : 0L)).heartbeatReplyDelay(config.hasPath(HB_REPLY_DELAY_KEY) ? config.getLong(HB_REPLY_DELAY_KEY) : 0L)).canPause(config.hasPath(CAN_PAUSE_KEY) ? config.getBoolean(CAN_PAUSE_KEY) : false);
        if (builder.mCanPause) {
            Config pauseConfig = config.getConfig(PAUSE_KEY);
            PauseBuilder pauseBuilder = new PauseBuilder(ConnectionRole.INITIATOR);
            pauseBuilder.duration(pauseConfig.getDuration(PAUSE_DURATION_KEY)).maxBacklogSize(pauseConfig.getInt(MAX_BACKLOG_SIZE_KEY)).discardPolicy((DiscardPolicy)pauseConfig.getEnum(DiscardPolicy.class, DISCARD_POLICY_KEY)).idleTime(pauseConfig.getDuration(IDLE_TIME_KEY)).maxConnectionTime(pauseConfig.getDuration(MAX_CONNECT_TIME_KEY));
            if (pauseConfig.hasPath(RESUME_ON_BACKLOG_SIZE_KEY)) {
                pauseBuilder.resumeOnBacklogSize(pauseConfig.getInt(RESUME_ON_BACKLOG_SIZE_KEY));
            }
            builder.pauseConfig(pauseBuilder.build());
        }
        return builder.build();
    }

    private static Dispatcher loadDispatcher(Config config) throws ConfigException {
        DispatcherBuilder builder = new DispatcherBuilder();
        builder.name(config.getString(NAME_KEY)).dispatcherType(DispatcherType.findType(builder.mName));
        if (builder.mType.isSpecial()) {
            EConfigure.loadSpecialDispatcher(builder, config);
        } else {
            EConfigure.loadDispatcher(builder, config);
        }
        return builder.build();
    }

    private static void loadDispatcher(DispatcherBuilder builder, Config config) throws ConfigException {
        builder.threadType(config.hasPath(THREAD_TYPE_KEY) ? ThreadType.find(config.getString(THREAD_TYPE_KEY)) : ThreadType.find(DEFAULT_THREAD_TYPE));
        switch (builder.mRunQueueType) {
            case SPINPARK: {
                builder.parkTime(config.hasPath(PARK_TIME_KEY) ? config.getLong(PARK_TIME_KEY) : 1000L);
            }
            case SPINYIELD: {
                builder.spinLimit(config.hasPath(SPIN_LIMIT_KEY) ? config.getLong(SPIN_LIMIT_KEY) : 2500000L);
                break;
            }
        }
        builder.priority(config.hasPath(PRIORITY_KEY) ? config.getInt(PRIORITY_KEY) : 5).quantum(config.hasPath(QUANTUM_KEY) ? config.getLong(QUANTUM_KEY) : 500000L).numberThreads(config.hasPath(NUM_THREADS_KEY) ? config.getInt(NUM_THREADS_KEY) : 4).isDefault(config.hasPath(DEFAULT_KEY) ? config.getBoolean(DEFAULT_KEY) : false).classes(builder.mIsDefault ? new Class[]{} : EConfigure.loadClasses(config));
    }

    private static void loadSpecialDispatcher(DispatcherBuilder builder, Config config) throws ConfigException {
        builder.isDefault(config.hasPath(DEFAULT_KEY) ? config.getBoolean(DEFAULT_KEY) : false).classes(builder.mIsDefault ? new Class[]{} : EConfigure.loadClasses(config)).threadType(ThreadType.BLOCKING).spinLimit(0L).parkTime(0L).priority(0).quantum(0L).numberThreads(0);
    }

    private static ConnectionType getConnectionType(String key, ConnectionType defaultType, net.sf.eBus.util.Properties p) {
        ConnectionType retval;
        String name = p.getProperty(key);
        if (name == null) {
            retval = defaultType;
        } else {
            try {
                retval = ConnectionType.valueOf(name);
            }
            catch (IllegalArgumentException argex) {
                throw new ConfigException.BadValue(key, "\"" + name + "\" is an invalid ConnectionType", (Throwable)argex);
            }
        }
        return retval;
    }

    private static ConnectionType getConnectionType(String key, ConnectionType defaultType, Preferences p) {
        ConnectionType retval;
        String name = p.get(key, null);
        if (name == null) {
            retval = defaultType;
        } else {
            try {
                retval = ConnectionType.valueOf(name);
            }
            catch (IllegalArgumentException argex) {
                throw new ConfigException.BadValue(key, "\"" + name + "\" is an invalid ConnectionType", (Throwable)argex);
            }
        }
        return retval;
    }

    private static int getPort(String key, int defaultPort, net.sf.eBus.util.Properties p) {
        int retval = p.getIntProperty(key, defaultPort);
        if (retval < 0 && retval != 0 || retval > 65535) {
            String badValue = p.getProperty(key);
            throw new ConfigException.BadValue(key, key + " invalid port (" + badValue + ")");
        }
        return retval;
    }

    private static int getPort(String key, int defaultPort, Preferences p) {
        int retval = p.getInt(key, defaultPort);
        if (retval < 0 && retval != 0 || retval > 65535) {
            throw new IllegalStateException(key + " invalid port (" + Integer.toString(retval) + ")");
        }
        return retval;
    }

    private static AddressFilter getFilter(String key, net.sf.eBus.util.Properties p) {
        AddressFilter retval;
        try {
            retval = AddressFilter.parse(p.getProperty(key));
        }
        catch (ParseException parsex) {
            String badValue = p.getProperty(key);
            throw new ConfigException.BadValue(key, key + " invalid address filter (" + badValue + ")", (Throwable)parsex);
        }
        return retval;
    }

    private static AddressFilter getFilter(String key, Preferences p) {
        AddressFilter retval;
        try {
            retval = AddressFilter.parse(p.get(key, null));
        }
        catch (ParseException parsex) {
            throw new IllegalStateException(parsex);
        }
        return retval;
    }

    private static InetSocketAddress getAddress(String name, String keyPrefix, net.sf.eBus.util.Properties p) {
        InetSocketAddress retval;
        String key = keyPrefix + HOST_KEY;
        String host = p.getProperty(key);
        if (Strings.isNullOrEmpty((String)host)) {
            throw new ConfigException.BadValue(key, "host is null or empty");
        }
        key = keyPrefix + PORT_KEY;
        int port = EConfigure.getPort(key, -1, p);
        try {
            retval = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException hostex) {
            throw new ConfigException.BadValue(key, name + " invalid address \"" + host + "\"", (Throwable)hostex);
        }
        return retval;
    }

    private static InetSocketAddress getAddress(String keyPrefix, Preferences p) {
        InetSocketAddress retval;
        String key = keyPrefix + HOST_KEY;
        String host = p.get(key, null);
        if (Strings.isNullOrEmpty((String)host)) {
            throw new ConfigException.BadValue(key, "host is null or empty");
        }
        key = keyPrefix + PORT_KEY;
        int port = EConfigure.getPort(key, 0, p);
        try {
            retval = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException hostex) {
            throw new ConfigException.BadValue(key, host, (Throwable)hostex);
        }
        return retval;
    }

    private static InetSocketAddress loadAddress(Config config) throws ConfigException {
        InetSocketAddress retval;
        String host = config.getString(HOST_KEY);
        int port = config.getInt(PORT_KEY);
        try {
            retval = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException hostex) {
            throw new ConfigException.BadValue(HOST_KEY, "\"" + host + "\" is not a valid address", (Throwable)hostex);
        }
        return retval;
    }

    private static int getSize(String key, int defaultValue, int minValue, net.sf.eBus.util.Properties p) {
        int retval = p.getIntProperty(key, defaultValue);
        if (retval < minValue) {
            String badValue = p.getProperty(key);
            throw new ConfigException.BadValue(key, badValue + " < " + minValue);
        }
        return retval;
    }

    private static int getSize(String key, int defaultValue, int minValue, Preferences p) {
        int retval = p.getInt(key, defaultValue);
        if (retval < minValue) {
            throw new IllegalStateException(key + " < " + Integer.toString(minValue));
        }
        return retval;
    }

    private static ByteOrder getByteOrder(String key, ByteOrder defaultValue, net.sf.eBus.util.Properties p) {
        ByteOrder retval;
        String value = p.getProperty(key);
        if (BIGENDIAN.equalsIgnoreCase(value)) {
            retval = ByteOrder.BIG_ENDIAN;
        } else if (LITTLEENDIAN.equalsIgnoreCase(value)) {
            retval = ByteOrder.LITTLE_ENDIAN;
        } else if (value == null || value.isEmpty()) {
            retval = defaultValue;
        } else {
            throw new ConfigException.BadValue(key, key + " value \"" + value + "\" is invalid");
        }
        return retval;
    }

    private static ByteOrder getByteOrder(String key, ByteOrder defaultValue, Preferences p) {
        ByteOrder retval;
        String value = p.get(key, null);
        if (BIGENDIAN.equalsIgnoreCase(value)) {
            retval = ByteOrder.BIG_ENDIAN;
        } else if (LITTLEENDIAN.equalsIgnoreCase(value)) {
            retval = ByteOrder.LITTLE_ENDIAN;
        } else if (value == null || value.isEmpty()) {
            retval = defaultValue;
        } else {
            throw new IllegalStateException(String.format("%s value \"%s\" invalid", key, value));
        }
        return retval;
    }

    private static ByteOrder loadByteOrder(Config config, String key) throws ConfigException {
        ByteOrder retval;
        if (!config.hasPathOrNull(BYTE_ORDER_KEY)) {
            retval = DEFAULT_BYTE_ORDER;
        } else {
            String value;
            switch (value = config.getString(key)) {
                case "BIG_ENDIAN": {
                    retval = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case "LITTLE_ENDIAN": {
                    retval = ByteOrder.LITTLE_ENDIAN;
                    break;
                }
                default: {
                    throw new ConfigException.BadValue(key, "\"" + value + "\" is not a valid java.nio.ByteOrder");
                }
            }
        }
        return retval;
    }

    private static long getDelay(String key, int defaultValue, long minValue, net.sf.eBus.util.Properties p) {
        long retval = p.getIntProperty(key, defaultValue);
        if (retval < minValue) {
            throw new IllegalStateException("negative " + key);
        }
        return retval;
    }

    private static long getDelay(String key, int defaultValue, long minValue, Preferences p) {
        long retval = p.getInt(key, defaultValue);
        if (retval < minValue) {
            throw new IllegalStateException("negative " + key);
        }
        return retval;
    }

    private static Class<?>[] getClasses(String key, net.sf.eBus.util.Properties p) {
        String[] classNames = p.getArrayProperty(key, ',');
        int size = classNames.length;
        if (size == 0) {
            throw new ConfigException.BadValue(key, "classes are missing or empty");
        }
        Class[] retval = new Class[size];
        for (int index = 0; index < size; ++index) {
            try {
                retval[index] = Class.forName(classNames[index]);
                continue;
            }
            catch (ClassNotFoundException jex) {
                throw new ConfigException.BadValue(key, "unknown class " + classNames[index], (Throwable)jex);
            }
        }
        return retval;
    }

    private static Class<?>[] getClasses(String key, Preferences p) {
        String[] classNames = p.get(key, "").split(KEY_SEP);
        int size = classNames.length;
        if (size == 0) {
            throw new MissingResourceException(String.format("%s missing or empty", key), Class.class.getName(), key);
        }
        Class[] retval = new Class[size];
        for (int index = 0; index < size; ++index) {
            try {
                retval[index] = Class.forName(classNames[index]);
                continue;
            }
            catch (ClassNotFoundException jex) {
                throw new MissingResourceException(String.format("unknown class %s", classNames[index]), Class.class.getName(), key);
            }
        }
        return retval;
    }

    private static Class<?>[] loadClasses(Config config) throws ConfigException {
        List classNames = config.getStringList(CLASSES_KEY);
        int index = 0;
        Class[] retval = new Class[classNames.size()];
        if (classNames.isEmpty()) {
            throw new ConfigException.BadValue(CLASSES_KEY, "classes are missing or empty");
        }
        for (String className : classNames) {
            try {
                retval[index] = Class.forName(className);
            }
            catch (ClassNotFoundException classex) {
                throw new ConfigException.BadValue(CLASSES_KEY, "\"" + className + "\" is an unknown class", (Throwable)classex);
            }
            ++index;
        }
        return retval;
    }

    private void storeService(Properties p) {
        Formatter names = new Formatter();
        String sep = "";
        for (Service service : this.mServices.values()) {
            String name = service.name();
            String keyPrefix = SERVICE_PREFIX + name + ".";
            AddressFilter filter = service.addressFilter();
            names.format("%s%s", sep, name);
            String key = keyPrefix + PORT_KEY;
            p.setProperty(key, Integer.toString(service.port()));
            key = keyPrefix + FILTER_KEY;
            p.setProperty(key, filter == null ? "" : filter.toString());
            key = keyPrefix + BYTE_ORDER_KEY;
            p.setProperty(key, service.byteOrder().toString());
            key = keyPrefix + INBUFFER_SIZE_KEY;
            p.setProperty(key, Integer.toString(service.inputBufferSize()));
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            p.setProperty(key, Integer.toString(service.outputBufferSize()));
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            p.setProperty(key, Integer.toString(service.messageQueueSize()));
        }
        p.setProperty("eBus.services", names.toString());
    }

    private void storeConnections(Properties p) {
        Formatter names = new Formatter();
        String sep = "";
        for (RemoteConnection connection : this.mRemoteConnections.values()) {
            String name = connection.name();
            String keyPrefix = CONNECTION_PREFIX + name + ".";
            InetSocketAddress address = connection.address();
            names.format("%s%s", sep, name);
            String key = keyPrefix + HOST_KEY;
            p.setProperty(key, address.getHostName());
            key = keyPrefix + PORT_KEY;
            p.setProperty(key, Integer.toString(address.getPort()));
            key = keyPrefix + BIND_PORT_KEY;
            p.setProperty(key, Integer.toString(connection.bindPort()));
            key = keyPrefix + BYTE_ORDER_KEY;
            p.setProperty(key, connection.byteOrder().toString());
            key = keyPrefix + INBUFFER_SIZE_KEY;
            p.setProperty(key, Integer.toString(connection.inputBufferSize()));
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            p.setProperty(key, Integer.toString(connection.outputBufferSize()));
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            p.setProperty(key, Integer.toString(connection.messageQueueSize()));
            key = keyPrefix + RECONNECT_KEY;
            p.setProperty(key, Boolean.toString(connection.reconnectFlag()));
            key = keyPrefix + RECONNECT_DELAY_KEY;
            p.setProperty(key, Long.toString(connection.reconnectTime()));
            key = keyPrefix + CAN_PAUSE_KEY;
            p.setProperty(key, Boolean.toString(connection.canPause()));
            if (connection.pauseConfiguration() != null) {
                this.storePause(keyPrefix + PAUSE_KEY + ".", connection.pauseConfiguration(), p);
            }
            sep = KEY_SEP;
        }
        p.setProperty("eBus.connections", names.toString());
    }

    private void storePause(String keyPrefix, PauseConfig config, Properties p) {
        String key = keyPrefix + PAUSE_DURATION_KEY;
        p.setProperty(key, config.duration().toString());
        key = keyPrefix + MAX_BACKLOG_SIZE_KEY;
        p.setProperty(key, Integer.toString(config.maxBacklogSize()));
        key = keyPrefix + DISCARD_POLICY_KEY;
        p.setProperty(key, config.discardPolicy().name());
        key = keyPrefix + IDLE_TIME_KEY;
        p.setProperty(key, config.idleTime().toString());
        key = keyPrefix + MAX_CONNECT_TIME_KEY;
        p.setProperty(key, config.maxConnectTime().toString());
        key = keyPrefix + RESUME_ON_BACKLOG_SIZE_KEY;
        p.setProperty(key, Integer.toString(config.resumeOnQueueLimit()));
    }

    private void storeDispatchers(Properties p) {
        String key;
        Formatter names = new Formatter();
        String sep = "";
        for (Dispatcher dispatcher : this.mDispatchers.values()) {
            String name = dispatcher.name();
            String keyPrefix = "eBus.dispatcher." + name + ".";
            names.format("%s%s", sep, name);
            key = keyPrefix + DEFAULT_KEY;
            p.setProperty(key, Boolean.toString(dispatcher.isDefault()));
            key = keyPrefix + PRIORITY_KEY;
            p.setProperty(key, String.valueOf(dispatcher.priority()));
            key = keyPrefix + QUANTUM_KEY;
            p.setProperty(key, Long.toString(dispatcher.quantum()));
            key = keyPrefix + NUM_THREADS_KEY;
            p.setProperty(key, Integer.toString(dispatcher.numberThreads()));
            sep = KEY_SEP;
        }
        key = "eBus.dispatchers";
        p.setProperty(key, names.toString());
    }

    private void storeService(Preferences p) {
        Formatter names = new Formatter();
        String sep = "";
        for (Service service : this.mServices.values()) {
            String name = service.name();
            String keyPrefix = SERVICE_PREFIX + name + ".";
            AddressFilter filter = service.addressFilter();
            names.format("%s%s", sep, name);
            String key = keyPrefix + PORT_KEY;
            p.putInt(key, service.port());
            key = keyPrefix + FILTER_KEY;
            p.put(key, filter == null ? "" : filter.toString());
            key = keyPrefix + INBUFFER_SIZE_KEY;
            p.putInt(key, service.inputBufferSize());
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            p.putInt(key, service.outputBufferSize());
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            p.putInt(key, service.messageQueueSize());
        }
        p.put("eBus.services", names.toString());
    }

    private void storeConnections(Preferences p) {
        Formatter names = new Formatter();
        String sep = "";
        for (RemoteConnection connection : this.mRemoteConnections.values()) {
            String name = connection.name();
            String keyPrefix = CONNECTION_PREFIX + name + ".";
            InetSocketAddress address = connection.address();
            names.format("%s%s", sep, name);
            String key = keyPrefix + HOST_KEY;
            p.put(key, address.getHostName());
            key = keyPrefix + PORT_KEY;
            p.putInt(key, address.getPort());
            key = keyPrefix + BIND_PORT_KEY;
            p.putInt(key, connection.bindPort());
            key = keyPrefix + INBUFFER_SIZE_KEY;
            p.putInt(key, connection.inputBufferSize());
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            p.putInt(key, connection.outputBufferSize());
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            p.putInt(key, connection.messageQueueSize());
            key = keyPrefix + RECONNECT_KEY;
            p.putBoolean(key, connection.reconnectFlag());
            key = keyPrefix + RECONNECT_DELAY_KEY;
            p.putLong(key, connection.reconnectTime());
            sep = KEY_SEP;
        }
        p.put("eBus.connections", names.toString());
    }

    private void storeDispatchers(Preferences p) {
        String key;
        Formatter names = new Formatter();
        String sep = "";
        for (Dispatcher dispatcher : this.mDispatchers.values()) {
            String name = dispatcher.name();
            String keyPrefix = "eBus.dispatcher." + name + ".";
            names.format("%s%s", sep, name);
            key = keyPrefix + DEFAULT_KEY;
            p.putBoolean(key, dispatcher.isDefault());
            key = keyPrefix + PRIORITY_KEY;
            p.putInt(key, dispatcher.priority());
            key = keyPrefix + QUANTUM_KEY;
            p.putLong(key, dispatcher.quantum());
            key = keyPrefix + NUM_THREADS_KEY;
            p.putInt(key, dispatcher.numberThreads());
            sep = KEY_SEP;
        }
        key = "eBus.dispatchers";
        p.put(key, names.toString());
    }

    static /* synthetic */ ByteOrder access$3100() {
        return DEFAULT_BYTE_ORDER;
    }

    public static final class PauseBuilder {
        private final ConnectionRole mRole;
        private Duration mDuration;
        private int mMaxBacklogSize;
        private DiscardPolicy mDiscardPolicy;
        private Duration mIdleTime;
        private Duration mMaxConnectTime;
        private int mResumeOnBacklogSize;

        private PauseBuilder(ConnectionRole role) {
            this.mRole = role;
            this.mDuration = Duration.ZERO;
            this.mMaxBacklogSize = 0;
            this.mIdleTime = Duration.ZERO;
            this.mMaxConnectTime = Duration.ZERO;
            this.mResumeOnBacklogSize = 0;
        }

        public PauseBuilder duration(Duration duration) {
            if (duration == null) {
                throw new ConfigException.BadValue(EConfigure.PAUSE_DURATION_KEY, "duration is null");
            }
            if (duration.compareTo(Duration.ZERO) <= 0) {
                throw new ConfigException.BadValue(EConfigure.PAUSE_DURATION_KEY, "duration <= 0");
            }
            this.mDuration = duration;
            return this;
        }

        public PauseBuilder maxBacklogSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.MAX_BACKLOG_SIZE_KEY, "size < 0");
            }
            this.mMaxBacklogSize = size;
            return this;
        }

        public PauseBuilder discardPolicy(DiscardPolicy policy) {
            if (this.mRole == ConnectionRole.ACCEPTOR) {
                throw new ConfigException.Generic("cannot set discard policy for acceptor connection");
            }
            if (policy == null) {
                throw new ConfigException.BadValue(EConfigure.DISCARD_POLICY_KEY, "policy is null");
            }
            this.mDiscardPolicy = policy;
            return this;
        }

        public PauseBuilder idleTime(Duration duration) {
            if (this.mRole == ConnectionRole.ACCEPTOR) {
                throw new ConfigException.Generic("cannot set idle time for acceptor connection");
            }
            if (duration == null) {
                throw new ConfigException.BadValue(EConfigure.IDLE_TIME_KEY, "duration is null");
            }
            if (duration.compareTo(Duration.ZERO) <= 0) {
                throw new ConfigException.BadValue(EConfigure.IDLE_TIME_KEY, "duration <= 0");
            }
            this.mIdleTime = duration;
            return this;
        }

        public PauseBuilder maxConnectionTime(Duration duration) {
            if (this.mRole == ConnectionRole.ACCEPTOR) {
                throw new ConfigException.Generic("cannot set max connection time for acceptor connection");
            }
            if (duration == null) {
                throw new ConfigException.BadValue(EConfigure.MAX_CONNECT_TIME_KEY, "duration is null");
            }
            if (duration.compareTo(Duration.ZERO) <= 0) {
                throw new ConfigException.BadValue(EConfigure.MAX_CONNECT_TIME_KEY, "duration <= 0");
            }
            this.mMaxConnectTime = duration;
            if (this.mIdleTime.equals(Duration.ZERO)) {
                this.mIdleTime = duration;
            }
            return this;
        }

        public PauseBuilder resumeOnBacklogSize(int size) {
            if (this.mRole == ConnectionRole.ACCEPTOR) {
                throw new ConfigException.Generic("cannot set max connection time for acceptor connection");
            }
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.RESUME_ON_BACKLOG_SIZE_KEY, "size < 0");
            }
            this.mResumeOnBacklogSize = size;
            return this;
        }

        public PauseConfig build() {
            this.validate();
            return new PauseConfig(this);
        }

        private void validate() {
            if (this.mDuration.equals(Duration.ZERO)) {
                throw new ConfigException.Generic("pause duration not set");
            }
            if (this.mRole == ConnectionRole.INITIATOR && this.mMaxConnectTime.equals(Duration.ZERO)) {
                throw new ConfigException.Generic("maximum connect time not set");
            }
        }
    }

    public static final class DispatcherBuilder {
        private String mName = null;
        private DispatcherType mType = null;
        private ThreadType mRunQueueType = null;
        private long mSpinLimit = 0L;
        private long mParkTime = 0L;
        private int mPriority = 5;
        private long mQuantum = 500000L;
        private int mNumThreads = 4;
        private boolean mIsDefault = false;
        private Class<?>[] mClasses = new Class[0];

        private DispatcherBuilder() {
        }

        public DispatcherBuilder configuration(Dispatcher config) {
            if (config != null) {
                this.mName = config.name();
                this.mType = config.dispatchType();
                this.mRunQueueType = config.runQueueType();
                this.mSpinLimit = config.spinLimit();
                this.mParkTime = config.parkTime();
                this.mPriority = config.priority();
                this.mQuantum = config.quantum();
                this.mNumThreads = config.numberThreads();
                this.mIsDefault = config.isDefault();
                this.mClasses = config.classes();
            }
            return this;
        }

        public DispatcherBuilder name(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new ConfigException.BadValue(EConfigure.NAME_KEY, "name is null or empty");
            }
            this.mName = name;
            return this;
        }

        public DispatcherBuilder dispatcherType(DispatcherType type) {
            if (type == null) {
                throw new ConfigException.BadValue(EConfigure.DISPATCHER_TYPE_KEY, "type is null or unknown");
            }
            this.mType = type;
            return this;
        }

        public DispatcherBuilder threadType(ThreadType type) {
            if (type == null) {
                throw new ConfigException.BadValue(EConfigure.THREAD_TYPE_KEY, "type is null or unknown");
            }
            this.mRunQueueType = type;
            return this;
        }

        public DispatcherBuilder spinLimit(long limit) {
            if (limit < 0L) {
                throw new ConfigException.BadValue(EConfigure.SPIN_LIMIT_KEY, "limit < zero");
            }
            this.mSpinLimit = limit;
            return this;
        }

        public DispatcherBuilder parkTime(long time) {
            if (time < 0L) {
                throw new ConfigException.BadValue(EConfigure.PARK_TIME_KEY, "time < zero");
            }
            this.mParkTime = time;
            return this;
        }

        public DispatcherBuilder priority(int priority) {
            if (priority < 0 || priority > 10) {
                throw new ConfigException.BadValue(EConfigure.PRIORITY_KEY, "priority out of bounds");
            }
            this.mPriority = priority;
            return this;
        }

        public DispatcherBuilder quantum(long quantum) {
            if (quantum < 0L) {
                throw new ConfigException.BadValue(EConfigure.QUANTUM_KEY, "quantum < zero");
            }
            this.mQuantum = quantum;
            return this;
        }

        public DispatcherBuilder numberThreads(int numThreads) {
            if (numThreads < 0) {
                throw new ConfigException.BadValue(EConfigure.NUM_THREADS_KEY, "numThreads < zero");
            }
            this.mNumThreads = numThreads;
            return this;
        }

        public DispatcherBuilder isDefault(boolean flag) {
            this.mIsDefault = flag;
            return this;
        }

        public DispatcherBuilder classes(Class<?>[] classes) {
            this.mClasses = classes == null ? new Class[0] : Arrays.copyOf(classes, classes.length);
            return this;
        }

        public Dispatcher build() {
            this.validate();
            return new Dispatcher(this);
        }

        private void validate() {
            if (this.mName == null) {
                throw new ConfigException.BadValue(EConfigure.NAME_KEY, "name not set");
            }
            if (this.mType == null) {
                throw new ConfigException.BadValue(EConfigure.DISPATCHER_TYPE_KEY, "dispatcher type not set");
            }
            if (this.mRunQueueType == null) {
                throw new ConfigException.BadValue(EConfigure.THREAD_TYPE_KEY, "thread type not set");
            }
            if (this.mRunQueueType == ThreadType.SPINPARK) {
                if (this.mSpinLimit <= 0L) {
                    throw new ConfigException.BadValue(EConfigure.SPIN_LIMIT_KEY, "spin limit not set for spin+park thread type");
                }
                if (this.mParkTime <= 0L) {
                    throw new ConfigException.BadValue(EConfigure.PARK_TIME_KEY, "park limit not set for spin+park thread type");
                }
            } else if (this.mRunQueueType == ThreadType.SPINYIELD && this.mSpinLimit <= 0L) {
                throw new ConfigException.BadValue(EConfigure.SPIN_LIMIT_KEY, "spin limit not set for spin+yield thread type");
            }
            if (!(this.mIsDefault || this.mClasses != null && this.mClasses.length != 0)) {
                throw new ConfigException.BadValue(EConfigure.CLASSES_KEY, "classes not set for non-default dispatcher");
            }
        }
    }

    public static final class ConnectionBuilder
    extends AbstractBuilder<ConnectionBuilder> {
        private InetSocketAddress mAddress = null;
        private int mBindPort = 0;
        private String mSelector = ENetConfigure.defaultSelector().name();
        private boolean mReconnectFlag = false;
        private long mReconnectTime = 0L;
        private ProtocolFamily mProtocol = StandardProtocolFamily.INET;

        private ConnectionBuilder() {
        }

        public ConnectionBuilder configuration(RemoteConnection config) {
            if (config != null) {
                super.configuration(config);
                this.mAddress = config.address();
                this.mBindPort = config.bindPort();
                this.mSelector = config.selector();
                this.mReconnectFlag = config.reconnectFlag();
                this.mReconnectTime = config.reconnectTime();
            }
            return this;
        }

        public ConnectionBuilder address(InetSocketAddress address) {
            if (address == null) {
                throw new ConfigException.BadValue(EConfigure.HOST_KEY, "address is null");
            }
            this.mAddress = address;
            return this;
        }

        public ConnectionBuilder bindPort(int port) {
            if (port < 0 || port > 65535) {
                throw new ConfigException.BadValue(EConfigure.BIND_PORT_KEY, "invalid bind port (" + port + ")");
            }
            this.mBindPort = port;
            return this;
        }

        public ConnectionBuilder selector(String selector) {
            if (Strings.isNullOrEmpty((String)selector)) {
                throw new ConfigException.BadValue(EConfigure.SELECTOR_KEY, "selector is null or empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new ConfigException.BadValue(EConfigure.SELECTOR_KEY, "\"" + selector + "\" unknown selector");
            }
            this.mSelector = selector;
            return this;
        }

        public ConnectionBuilder reconnect(boolean flag) {
            this.mReconnectFlag = flag;
            return this;
        }

        public ConnectionBuilder reconnectDelay(long time) {
            if (time < 0L) {
                throw new ConfigException.BadValue(EConfigure.RECONNECT_DELAY_KEY, "reconnect time < 0");
            }
            this.mReconnectTime = time;
            return this;
        }

        public ConnectionBuilder protocol(ProtocolFamily protocol) {
            this.mProtocol = Objects.requireNonNull(protocol, "protocol is null");
            return this;
        }

        public RemoteConnection build() {
            this.validate();
            return new RemoteConnection(this);
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.mName == null) {
                throw new ConfigException.BadValue(EConfigure.NAME_KEY, "connection name not set");
            }
            if (this.mAddress == null) {
                throw new ConfigException.BadValue(EConfigure.HOST_KEY, "address not set");
            }
            if (this.mReconnectFlag && this.mReconnectTime <= 0L) {
                throw new ConfigException.BadValue(EConfigure.RECONNECT_DELAY_KEY, "reconnect time == zero");
            }
        }
    }

    public static final class ServerBuilder
    extends AbstractBuilder<ServerBuilder> {
        private int mPort = 0;
        private AddressFilter mAddressFilter = null;
        private String mServiceSelector;
        private String mConnSelector = this.mServiceSelector = ENetConfigure.defaultSelector().name();

        private ServerBuilder() {
        }

        public ServerBuilder configuration(Service config) {
            if (config != null) {
                super.configuration(config);
                this.mPort = config.port();
                this.mAddressFilter = config.addressFilter();
                this.mServiceSelector = config.serviceSelector();
                this.mConnSelector = config.connectionSelector();
            }
            return this;
        }

        public ServerBuilder port(int port) {
            if (port < 0 || port > 65535) {
                throw new ConfigException.BadValue(EConfigure.PORT_KEY, "invalid port (" + port + ")");
            }
            this.mPort = port;
            return this;
        }

        public ServerBuilder addressFilter(AddressFilter filter) {
            this.mAddressFilter = filter;
            return this;
        }

        public ServerBuilder serviceSelector(String selector) {
            if (Strings.isNullOrEmpty((String)selector)) {
                throw new ConfigException.BadValue(EConfigure.SVC_SELECTOR_KEY, "service selector is null or empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new ConfigException.BadValue(EConfigure.SVC_SELECTOR_KEY, "\"" + selector + "\" unknown service selector");
            }
            this.mServiceSelector = selector;
            return this;
        }

        public ServerBuilder connectionSelector(String selector) {
            if (Strings.isNullOrEmpty((String)selector)) {
                throw new ConfigException.BadValue(EConfigure.CONN_SELECTOR_KEY, "connection selector is null or empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new ConfigException.BadValue(EConfigure.CONN_SELECTOR_KEY, "\"" + selector + "\" unknown connection selector");
            }
            this.mConnSelector = selector;
            return this;
        }

        public Service build() {
            this.validate();
            return new Service(this);
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.mPort == 0) {
                throw new ConfigException.BadValue(EConfigure.PORT_KEY, "service port not set");
            }
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder> {
        protected String mName = null;
        private ConnectionType mConnectionType = ConnectionType.TCP;
        protected int mInputBufferSize = 0;
        protected int mOutputBufferSize = 0;
        protected ByteOrder mByteOrder = EConfigure.access$3100();
        protected int mMsgQueueSize = 0;
        protected long mHbDelay = 0L;
        protected long mHbReplyDelay = 0L;
        protected SSLContext mSSLContext = null;
        protected boolean mCanPause = false;
        protected PauseConfig mPauseConfig = null;
        protected boolean mLoaderFlag = false;

        protected AbstractBuilder() {
        }

        public final T name(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new ConfigException.BadValue(EConfigure.NAME_KEY, "name is null or empty");
            }
            this.mName = name;
            return (T)this;
        }

        public final T connectionType(ConnectionType connType) {
            if (connType == null) {
                throw new ConfigException.BadValue(EConfigure.CONN_TYPE_KEY, "connType is null");
            }
            this.mConnectionType = connType;
            return (T)this;
        }

        public final T inputBufferSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.INBUFFER_SIZE_KEY, "input buffer size < 0");
            }
            this.mInputBufferSize = size;
            return (T)this;
        }

        public final T outputBufferSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.OUTBUFFER_SIZE_KEY, "output buffer size < 0");
            }
            this.mOutputBufferSize = size;
            return (T)this;
        }

        public final T byteOrder(ByteOrder byteOrder) {
            if (byteOrder == null) {
                throw new ConfigException.BadValue(EConfigure.BYTE_ORDER_KEY, "byteOrder is null");
            }
            this.mByteOrder = byteOrder;
            return (T)this;
        }

        public final T messageQueueSize(int size) {
            if (size < 0) {
                throw new ConfigException.BadValue(EConfigure.MSG_QUEUE_SIZE_KEY, "message queue size < 0");
            }
            this.mMsgQueueSize = size;
            return (T)this;
        }

        public final T heartbeatDelay(long delay) {
            if (delay < 0L) {
                throw new ConfigException.BadValue(EConfigure.HB_DELAY_KEY, "heartbeat delay < 0");
            }
            this.mHbDelay = delay;
            return (T)this;
        }

        public final T heartbeatReplyDelay(long delay) {
            if (delay < 0L) {
                throw new ConfigException.BadValue(EConfigure.HB_REPLY_DELAY_KEY, "heartbeat reply delay < 0");
            }
            this.mHbReplyDelay = delay;
            return (T)this;
        }

        public final T sslContext(SSLContext context) {
            if (context == null) {
                throw new ConfigException.BadValue(EConfigure.SSL_CONTEXT_KEY, "context is null");
            }
            this.mSSLContext = context;
            return (T)this;
        }

        public final T canPause(boolean flag) {
            this.mCanPause = flag;
            return (T)this;
        }

        public final T pauseConfig(PauseConfig pc) {
            if (!this.mCanPause) {
                throw new ConfigException.Generic("connection cannot be paused");
            }
            if (pc == null) {
                throw new ConfigException.BadValue(EConfigure.PAUSE_KEY, "pause config is null");
            }
            this.mPauseConfig = pc;
            return (T)this;
        }

        protected T configuration(AbstractConfig config) {
            this.mName = config.name();
            this.mConnectionType = config.connectionType();
            this.mInputBufferSize = config.inputBufferSize();
            this.mOutputBufferSize = config.outputBufferSize();
            this.mByteOrder = config.byteOrder();
            this.mMsgQueueSize = config.messageQueueSize();
            this.mHbDelay = config.heartbeatDelay();
            this.mHbReplyDelay = config.heartbeatReplyDelay();
            this.mSSLContext = config.sslContext();
            this.mCanPause = config.canPause();
            this.mPauseConfig = config.pauseConfiguration();
            return (T)this;
        }

        protected final T loaderFlag(boolean flag) {
            this.mLoaderFlag = flag;
            return (T)this;
        }

        protected void validate() {
            if (this.mName == null) {
                throw new ConfigException.BadValue(EConfigure.NAME_KEY, "service name is not set");
            }
            if (this.mConnectionType == ConnectionType.SECURE_TCP && !this.mLoaderFlag && this.mSSLContext == null) {
                throw new ConfigException.BadValue(EConfigure.SSL_CONTEXT_KEY, "SSL context not provided for secure connection");
            }
            if (this.mConnectionType != ConnectionType.SECURE_TCP && this.mSSLContext != null) {
                throw new ConfigException.BadValue(EConfigure.SSL_CONTEXT_KEY, "SSL context provided for non-secure connection");
            }
            if (this.mCanPause && this.mPauseConfig == null) {
                throw new ConfigException.Missing("pause configuration not set");
            }
        }
    }

    public static final class PauseConfig {
        private final Duration mDuration;
        private final int mMaxBacklogSize;
        private final DiscardPolicy mDiscardPolicy;
        private final Duration mIdleTime;
        private final Duration mMaxConnectTime;
        private final int mResumeOnQueueLimit;

        private PauseConfig(PauseBuilder builder) {
            this.mDuration = builder.mDuration;
            this.mMaxBacklogSize = builder.mMaxBacklogSize;
            this.mDiscardPolicy = builder.mDiscardPolicy;
            this.mIdleTime = builder.mIdleTime;
            this.mMaxConnectTime = builder.mMaxConnectTime;
            this.mResumeOnQueueLimit = builder.mResumeOnBacklogSize;
        }

        public String toString() {
            StringBuilder retval = new StringBuilder();
            retval.append("[duration=").append(this.mDuration).append(", backlog size=").append(this.mMaxBacklogSize);
            if (this.mDiscardPolicy != null) {
                retval.append(", discard policy=").append((Object)this.mDiscardPolicy);
            }
            retval.append(", idle time=").append(this.mIdleTime).append(", max connect time=").append(this.mMaxConnectTime).append(", resume-on-send=").append(this.mResumeOnQueueLimit).append("]");
            return retval.toString();
        }

        public Duration duration() {
            return this.mDuration;
        }

        public int maxBacklogSize() {
            return this.mMaxBacklogSize;
        }

        public DiscardPolicy discardPolicy() {
            return this.mDiscardPolicy;
        }

        public Duration idleTime() {
            return this.mIdleTime;
        }

        public Duration maxConnectTime() {
            return this.mMaxConnectTime;
        }

        public int resumeOnQueueLimit() {
            return this.mResumeOnQueueLimit;
        }
    }

    public static final class Dispatcher
    implements Comparable<Dispatcher> {
        private final String mName;
        private final DispatcherType mType;
        private final ThreadType mRunQueueType;
        private final long mSpinLimit;
        private final long mParkTime;
        private final int mPriority;
        private final long mQuantum;
        private final int mNumThreads;
        private final boolean mIsDefault;
        private final Class<?>[] mClasses;

        Dispatcher(DispatcherBuilder builder) {
            this.mName = builder.mName;
            this.mType = builder.mType;
            this.mRunQueueType = builder.mRunQueueType;
            this.mSpinLimit = builder.mSpinLimit;
            this.mParkTime = builder.mParkTime;
            this.mPriority = builder.mPriority;
            this.mQuantum = builder.mQuantum;
            this.mNumThreads = builder.mNumThreads;
            this.mIsDefault = builder.mIsDefault;
            this.mClasses = builder.mClasses;
        }

        @Override
        public int compareTo(Dispatcher o) {
            return this.mName.compareTo(o.mName);
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode) {
                retcode = this.mName.equals(((Dispatcher)o).mName);
            }
            return retcode;
        }

        public int hashCode() {
            return this.mName.hashCode();
        }

        public String toString() {
            Formatter retval = new Formatter();
            retval.format("[%s]%n", this.mName);
            retval.format("       priority: %s%n", this.mPriority);
            retval.format("     is default: %b%n", this.mIsDefault);
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public DispatcherType dispatchType() {
            return this.mType;
        }

        public ThreadType runQueueType() {
            return this.mRunQueueType;
        }

        public long spinLimit() {
            return this.mSpinLimit;
        }

        public long parkTime() {
            return this.mParkTime;
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public Class<?>[] classes() {
            return Arrays.copyOf(this.mClasses, this.mClasses.length);
        }

        public int priority() {
            return this.mPriority;
        }

        public long quantum() {
            return this.mQuantum;
        }

        public int numberThreads() {
            return this.mNumThreads;
        }
    }

    public static final class RemoteConnection
    extends AbstractConfig
    implements Comparable<RemoteConnection> {
        private final InetSocketAddress mAddress;
        private final int mBindPort;
        private final String mSelector;
        private final boolean mReconnectFlag;
        private final long mReconnectTime;
        private final ProtocolFamily mProtocol;

        RemoteConnection(ConnectionBuilder builder) {
            super(builder);
            this.mAddress = builder.mAddress;
            this.mBindPort = builder.mBindPort;
            this.mSelector = builder.mSelector;
            this.mReconnectFlag = builder.mReconnectFlag;
            this.mReconnectTime = builder.mReconnectTime;
            this.mProtocol = builder.mProtocol;
        }

        @Override
        public int compareTo(RemoteConnection conn) {
            InetSocketAddressComparator comparator = new InetSocketAddressComparator();
            return comparator.compare(this.mAddress, conn.mAddress);
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof RemoteConnection) {
                retcode = this.mAddress.equals(((RemoteConnection)o).mAddress);
            }
            return retcode;
        }

        public int hashCode() {
            return this.mAddress.hashCode();
        }

        public String toString() {
            Formatter retval = new Formatter();
            retval.format("[%s] address: %s%n", this.mName, this.mAddress).format("     connection type: %s%n", new Object[]{this.mConnectionType}).format("           bind port: %d%n", this.mBindPort).format("   input buffer size: %,d%n", this.mInputBufferSize).format("  output buffer size: %,d%n", this.mOutputBufferSize).format("   buffer byte order: %s%n", this.mByteOrder).format("          queue size: %,d%n", this.mMsgQueueSize).format("            selector: %s%n", this.mSelector).format("           reconnect: %b%n", this.mReconnectFlag);
            if (this.mReconnectFlag) {
                retval.format("      reconnect time: %,d msecs%n", this.mReconnectTime);
            }
            if (this.mConnectionType == ConnectionType.SECURE_TCP) {
                retval.format("       SSL context: %s%n", this.mSSLContext);
            }
            if (this.mConnectionType == ConnectionType.UDP) {
                retval.format("          protocol: %s%n", this.mProtocol);
            }
            return retval.toString();
        }

        public InetSocketAddress address() {
            return this.mAddress;
        }

        public int bindPort() {
            return this.mBindPort;
        }

        public String selector() {
            return this.mSelector;
        }

        public boolean reconnectFlag() {
            return this.mReconnectFlag;
        }

        public long reconnectTime() {
            return this.mReconnectTime;
        }

        public ProtocolFamily protocol() {
            return this.mProtocol;
        }
    }

    public static final class Service
    extends AbstractConfig
    implements Comparable<Service> {
        private final int mPort;
        private final AddressFilter mAddressFilter;
        private final String mServiceSelector;
        private final String mConnSelector;

        Service(ServerBuilder builder) {
            super(builder);
            this.mPort = builder.mPort;
            this.mAddressFilter = builder.mAddressFilter;
            this.mServiceSelector = builder.mServiceSelector;
            this.mConnSelector = builder.mConnSelector;
        }

        @Override
        public int compareTo(Service service) {
            return this.mPort - service.mPort;
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof Service) {
                Service svc = (Service)o;
                retcode = this.mConnectionType == svc.mConnectionType && this.mPort == svc.mPort;
            }
            return retcode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mConnectionType, this.mPort});
        }

        public String toString() {
            Formatter retval = new Formatter();
            retval.format("[%s %d]%n", new Object[]{this.mConnectionType, this.mPort}).format("address filter: %s%n", this.mAddressFilter).format("socket input size: %,d%n", this.mInputBufferSize).format("socket output size: %,d%n", this.mOutputBufferSize).format(" socket byte order: %s%n", this.mByteOrder).format("    max queue size: %,d%n", this.mMsgQueueSize).format("          selector: %s%n", this.mConnSelector);
            if (this.mConnectionType == ConnectionType.SECURE_TCP) {
                retval.format("       SSL context: %s%n", this.mSSLContext);
            }
            retval.format("         can pause: %b%n", this.mCanPause);
            if (this.mCanPause) {
                retval.format("      pause config: %s%n", this.mPauseConfig);
            }
            return retval.toString();
        }

        public int port() {
            return this.mPort;
        }

        public AddressFilter addressFilter() {
            return this.mAddressFilter;
        }

        public String serviceSelector() {
            return this.mServiceSelector;
        }

        public String connectionSelector() {
            return this.mConnSelector;
        }
    }

    public static abstract class AbstractConfig {
        protected final String mName;
        protected final ConnectionType mConnectionType;
        protected final int mInputBufferSize;
        protected final int mOutputBufferSize;
        protected final ByteOrder mByteOrder;
        protected final int mMsgQueueSize;
        protected final long mHbDelay;
        protected final long mHbReplyDelay;
        protected final SSLContext mSSLContext;
        protected final boolean mCanPause;
        protected final PauseConfig mPauseConfig;

        protected AbstractConfig(AbstractBuilder<?> builder) {
            this.mName = builder.mName;
            this.mConnectionType = ((AbstractBuilder)builder).mConnectionType;
            this.mInputBufferSize = builder.mInputBufferSize;
            this.mOutputBufferSize = builder.mOutputBufferSize;
            this.mByteOrder = builder.mByteOrder;
            this.mMsgQueueSize = builder.mMsgQueueSize;
            this.mHbDelay = builder.mHbDelay;
            this.mHbReplyDelay = builder.mHbReplyDelay;
            this.mSSLContext = builder.mSSLContext;
            this.mCanPause = builder.mCanPause;
            this.mPauseConfig = builder.mPauseConfig;
        }

        public final String name() {
            return this.mName;
        }

        public final ConnectionType connectionType() {
            return this.mConnectionType;
        }

        public final int inputBufferSize() {
            return this.mInputBufferSize;
        }

        public final int outputBufferSize() {
            return this.mOutputBufferSize;
        }

        public final ByteOrder byteOrder() {
            return this.mByteOrder;
        }

        public final int messageQueueSize() {
            return this.mMsgQueueSize;
        }

        public final long heartbeatDelay() {
            return this.mHbDelay;
        }

        public final long heartbeatReplyDelay() {
            return this.mHbReplyDelay;
        }

        public final SSLContext sslContext() {
            return this.mSSLContext;
        }

        public final boolean canPause() {
            return this.mCanPause;
        }

        public final PauseConfig pauseConfiguration() {
            return this.mPauseConfig;
        }
    }

    public static enum ConnectionRole {
        INITIATOR,
        ACCEPTOR;

    }

    public static enum DiscardPolicy {
        OLDEST_FIRST,
        YOUNGEST_FIRST;

    }

    public static enum DispatcherType {
        EBUS(false, null),
        JAVAFX(true, task -> {
            if (Platform.isFxApplicationThread()) {
                try {
                    task.run();
                }
                catch (Exception jex) {
                    System.err.println(jex.getLocalizedMessage());
                }
            } else {
                Platform.runLater((Runnable)task);
            }
        }),
        SWING(true, task -> {
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    task.run();
                }
                catch (Exception jex) {
                    System.err.println(jex.getLocalizedMessage());
                }
            } else {
                SwingUtilities.invokeLater(task);
            }
        });

        private final boolean mSpecial;
        private final Consumer<Runnable> mDispatchHandle;

        private DispatcherType(boolean special, Consumer<Runnable> handle) {
            this.mSpecial = special;
            this.mDispatchHandle = handle;
        }

        public boolean isSpecial() {
            return this.mSpecial;
        }

        public Consumer<Runnable> dispatchHandle() {
            return this.mDispatchHandle;
        }

        public static DispatcherType findType(String name) {
            DispatcherType[] types = DispatcherType.values();
            int numTypes = types.length;
            DispatcherType retval = null;
            for (int index = 0; index < numTypes && retval == null; ++index) {
                if (!name.equalsIgnoreCase(types[index].name())) continue;
                retval = types[index];
            }
            if (retval == null) {
                retval = EBUS;
            }
            return retval;
        }
    }

    public static enum ConnectionType {
        TCP,
        SECURE_TCP,
        UDP;

    }
}

