/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.config.ThreadType;

public final class ENetConfigure {
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    public static final int ANY_PORT = -1;
    public static final String SELECTORS_KEY = "selectors";
    public static final String SELECTOR_PREFIX = "eBus.net.selector";
    public static final String NAME_KEY = "name";
    public static final String TYPE_KEY = "type";
    public static final String DEFAULT_KEY = "isDefault";
    public static final String PRIORITY_KEY = "priority";
    public static final String SPIN_LIMIT_KEY = "spinLimit";
    public static final String PARK_TIME_KEY = "parkTime";
    private static final char KEY_IFS = ',';
    public static final int DEFAULT_PRIORITY = 5;
    public static final int DEFAULT_SPIN_LIMIT = 2500000;
    public static final int DEFAULT_PARK_TIME = 1000;
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final ThreadType DEFAULT_SELECTOR_TYPE = ThreadType.BLOCKING;
    private static final String DEFAULT_SELECTOR = "eBus:selectorThread:__DEFAULT__";
    private static SelectorInfo sDefaultSelector;
    private static Map<String, SelectorInfo> sSelectors;
    private static final Logger sLogger;

    private ENetConfigure() {
    }

    public static SelectorInfo defaultSelector() {
        return sDefaultSelector;
    }

    public static boolean isKnownSelector(String name) {
        return sSelectors.containsKey(name);
    }

    public static SelectorInfo selector(String name) {
        return sSelectors.get(name);
    }

    public static Map<String, SelectorInfo> selectors() {
        return sSelectors;
    }

    public static String asText() {
        String sep = "";
        Formatter retval = new Formatter();
        for (SelectorInfo info : sSelectors.values()) {
            retval.format("%s%s", sep, info);
            sep = "\\n";
        }
        return retval.toString();
    }

    public static void load(Properties props) {
        ENetConfigure.load(new net.sf.eBus.util.Properties(props));
    }

    public static void load(net.sf.eBus.util.Properties props) {
        String[] names;
        HashMap<String, SelectorInfo> selectors = new HashMap<String, SelectorInfo>();
        String key = "eBus.selectors";
        for (String name : names = props.getArrayProperty("eBus.selectors", ',')) {
            if (selectors.containsKey(name)) {
                sLogger.warning(String.format("Selector %s appears twice in %s, ignored.", name, "eBus.selectors"));
                continue;
            }
            selectors.put(name, ENetConfigure.loadInfo(name, props));
        }
        sSelectors = Collections.unmodifiableMap(selectors);
    }

    public static void load(Config config) {
        HashMap<String, SelectorInfo> selectors = new HashMap<String, SelectorInfo>();
        for (ConfigObject co : config.getObjectList(SELECTORS_KEY)) {
            SelectorInfo selector = ENetConfigure.loadInfo(co.toConfig());
            selectors.put(selector.name(), selector);
        }
        sSelectors = Collections.unmodifiableMap(selectors);
    }

    public static SelectorInfoBuilder selectorBuilder() {
        return new SelectorInfoBuilder();
    }

    static void load(Map<String, SelectorInfo> selectors) {
        if (selectors == null || selectors.isEmpty()) {
            throw new IllegalArgumentException("selectors is null or empty");
        }
        sSelectors = Collections.unmodifiableMap(selectors);
        selectors.values().stream().filter(selector -> selector.isDefault()).forEachOrdered(selector -> {
            sDefaultSelector = selector;
        });
    }

    private static void loadConfigFile(String configFile) {
        try {
            net.sf.eBus.util.Properties props = net.sf.eBus.util.Properties.loadProperties((String)configFile);
            ENetConfigure.load(props);
            for (SelectorInfo sInfo : sSelectors.values()) {
                if (!sInfo.isDefault()) continue;
                sDefaultSelector = sInfo;
                break;
            }
        }
        catch (IOException | IllegalArgumentException jex) {
            String reason = jex.getMessage();
            if (reason == null || reason.isEmpty()) {
                reason = "(no reason given)";
            }
            sLogger.log(Level.WARNING, String.format("Error loading eBus network configuration from %s, %s.", configFile, reason), jex);
        }
    }

    private static void loadJsonFile(String jsonFileName) {
        File jsonFile = new File(jsonFileName);
        Config netConfig = ConfigFactory.parseFile((File)jsonFile);
        ENetConfigure.load(netConfig);
    }

    private static SelectorInfo loadInfo(String name, net.sf.eBus.util.Properties props) {
        String keyPrefix = "eBus.net.selector." + name + ".";
        long spinLimit = 0L;
        long parkTime = 0L;
        String key = keyPrefix + TYPE_KEY;
        String value = props.getProperty(key);
        if (Strings.isNullOrEmpty((String)value)) {
            throw new ConfigException.BadValue(key, key + " is missing");
        }
        ThreadType type = ThreadType.find(value);
        if (type == null) {
            throw new ConfigException.BadValue(key, "\"" + value + "\" is not a valid selector type");
        }
        key = keyPrefix + DEFAULT_KEY;
        boolean defaultFlag = props.getBooleanProperty(key, false);
        key = keyPrefix + PRIORITY_KEY;
        int priority = props.getIntProperty(key, 5);
        if (priority < 1 || priority > 10) {
            throw new ConfigException.BadValue(key, "\"" + value + "\" is not a valid thread priority");
        }
        if ((type == ThreadType.SPINPARK || type == ThreadType.SPINYIELD) && (spinLimit = (long)props.getIntProperty(key = keyPrefix + SPIN_LIMIT_KEY, 2500000)) <= 0L) {
            throw new ConfigException.BadValue(key, "\"" + props.getProperty(key) + "\" is not a valid spin limit");
        }
        if (type == ThreadType.SPINPARK && (parkTime = (long)props.getIntProperty(key = keyPrefix + PARK_TIME_KEY, 1000)) <= 0L) {
            throw new ConfigException.BadValue(key, "\"" + props.getProperty(key) + "\" is not a valid park time");
        }
        return new SelectorInfoBuilder().name(name).type(type).isDefault(defaultFlag).priority(priority).spinLimit(spinLimit).parkTime(parkTime).build();
    }

    private static SelectorInfo loadInfo(Config config) {
        String value = config.getString(TYPE_KEY);
        ThreadType type = ThreadType.find(value);
        SelectorInfoBuilder builder = new SelectorInfoBuilder();
        if (type == null) {
            throw new ConfigException.BadValue(TYPE_KEY, "\"" + value + "\" is not a valid selector type");
        }
        builder.name(config.getString(NAME_KEY)).type(type).isDefault(config.getBoolean(DEFAULT_KEY)).priority(config.getInt(PRIORITY_KEY));
        if (builder.type() == ThreadType.SPINPARK || builder.type() == ThreadType.SPINYIELD) {
            builder.spinLimit(config.getLong(SPIN_LIMIT_KEY));
        }
        if (builder.type() == ThreadType.SPINPARK) {
            builder.parkTime(config.getLong(PARK_TIME_KEY));
        }
        return builder.build();
    }

    static {
        sLogger = Logger.getLogger(ENetConfigure.class.getName());
        String configFile = System.getProperty("net.sf.eBus.config.file");
        String jsonFile = System.getProperty("net.sf.eBus.config.jsonFile");
        sDefaultSelector = null;
        if (!Strings.isNullOrEmpty((String)configFile) && !Strings.isNullOrEmpty((String)jsonFile)) {
            throw new IllegalStateException(String.format("both %s and %s defined; only one is allowed", "net.sf.eBus.config.file", "net.sf.eBus.config.jsonFile"));
        }
        if (configFile != null && !configFile.isEmpty()) {
            ENetConfigure.loadConfigFile(configFile);
        } else if (!Strings.isNullOrEmpty((String)jsonFile)) {
            ENetConfigure.loadJsonFile(jsonFile);
        }
        if (sDefaultSelector == null) {
            SelectorInfoBuilder builder = new SelectorInfoBuilder();
            sDefaultSelector = builder.name(DEFAULT_SELECTOR).type(DEFAULT_SELECTOR_TYPE).isDefault(true).priority(5).build();
        }
        if (sSelectors == null) {
            HashMap<String, SelectorInfo> selectors = new HashMap<String, SelectorInfo>(1);
            selectors.put(sDefaultSelector.name(), sDefaultSelector);
            sSelectors = Collections.unmodifiableMap(selectors);
        }
    }

    public static final class SelectorInfo
    implements Comparable<SelectorInfo> {
        private final String mName;
        private final ThreadType mType;
        private final boolean mIsDefault;
        private final int mPriority;
        private final long mSpinLimit;
        private final long mParkTime;

        private SelectorInfo(String name, ThreadType type, boolean isDefault, int priority, long spinLimit, long parkTime) {
            this.mName = name;
            this.mType = type;
            this.mIsDefault = isDefault;
            this.mPriority = priority;
            this.mSpinLimit = spinLimit;
            this.mParkTime = parkTime;
        }

        @Override
        public int compareTo(SelectorInfo selector) {
            return this.mName.compareTo(selector.mName);
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof SelectorInfo) {
                SelectorInfo si = (SelectorInfo)o;
                retcode = this.mName.equals(si.name()) && this.mType == si.type() && this.mIsDefault == si.isDefault() && this.mPriority == si.priority() && this.mSpinLimit == si.spinLimit() && this.mParkTime == si.parkTime();
            }
            return retcode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mName, this.mType, this.mIsDefault, this.mPriority, this.mSpinLimit, this.mParkTime});
        }

        public String toString() {
            Formatter retval = new Formatter();
            retval.format("[%s]%n", this.mName);
            retval.format("selector type: %s%n", new Object[]{this.mType});
            retval.format("     priority: %s%n", this.mPriority);
            retval.format("   is default: %b%n", this.mIsDefault);
            if (this.mType == ThreadType.SPINPARK) {
                retval.format("   spin limit: %,d%n", this.mSpinLimit);
                retval.format("    park time: %,d nanoseconds%n", this.mParkTime);
            }
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public ThreadType type() {
            return this.mType;
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public int priority() {
            return this.mPriority;
        }

        public long spinLimit() {
            return this.mSpinLimit;
        }

        public long parkTime() {
            return this.mParkTime;
        }
    }

    public static final class SelectorInfoBuilder {
        private String mName = null;
        private ThreadType mType = null;
        private boolean mIsDefault = false;
        private int mPriority = 5;
        private long mSpinLimit = 0L;
        private long mParkTime = 0L;

        private SelectorInfoBuilder() {
        }

        public String name() {
            return this.mName;
        }

        public ThreadType type() {
            return this.mType;
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public int priority() {
            return this.mPriority;
        }

        public long spinLimit() {
            return this.mSpinLimit;
        }

        public long parkTime() {
            return this.mParkTime;
        }

        public SelectorInfoBuilder name(String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                throw new ConfigException.BadValue(ENetConfigure.NAME_KEY, "\"" + name + "\" is null or empty");
            }
            this.mName = name;
            return this;
        }

        public SelectorInfoBuilder type(ThreadType type) {
            if (type == null) {
                throw new ConfigException.BadValue("runQueueType", "type is null");
            }
            this.mType = type;
            return this;
        }

        public SelectorInfoBuilder isDefault(boolean flag) {
            this.mIsDefault = flag;
            return this;
        }

        public SelectorInfoBuilder priority(int priority) {
            if (priority < 1 || priority > 10) {
                throw new ConfigException.BadValue(ENetConfigure.PRIORITY_KEY, String.format("%d is not valid; must be >= %d and <= %d", priority, 1, 10));
            }
            this.mPriority = priority;
            return this;
        }

        public SelectorInfoBuilder spinLimit(long limit) {
            if (limit <= 0L) {
                throw new ConfigException.BadValue(ENetConfigure.SPIN_LIMIT_KEY, limit + " <= zero");
            }
            this.mSpinLimit = limit;
            return this;
        }

        public SelectorInfoBuilder parkTime(long time) {
            if (time <= 0L) {
                throw new ConfigException.BadValue(ENetConfigure.PARK_TIME_KEY, time + " <= zero");
            }
            this.mParkTime = time;
            return this;
        }

        public SelectorInfo build() {
            this.validate();
            return new SelectorInfo(this.mName, this.mType, this.mIsDefault, this.mPriority, this.mSpinLimit, this.mParkTime);
        }

        private void validate() {
            if (Strings.isNullOrEmpty((String)this.mName)) {
                throw new ConfigException.BadValue(ENetConfigure.NAME_KEY, "selector name not configured");
            }
            if (this.mType == null) {
                throw new ConfigException.BadValue(ENetConfigure.TYPE_KEY, "selector type not configured");
            }
            if ((this.mType == ThreadType.SPINPARK || this.mType == ThreadType.SPINYIELD) && this.mSpinLimit == 0L) {
                this.mSpinLimit = 2500000L;
            }
            if (this.mType == ThreadType.SPINPARK && this.mParkTime == 0L) {
                this.mParkTime = 1000L;
            }
        }
    }
}

