/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.config.ThreadType;

public class ENetConfigure {
    public static final int MIN_PORT = 0;
    public static final int MAX_PORT = 65535;
    public static final int ANY_PORT = -1;
    public static final String SELECTORS_KEY = "eBus.net.selectors";
    public static final String SELECTOR_PREFIX = "eBus.net.selector.";
    public static final String TYPE_KEY = ".type";
    public static final String DEFAULT_KEY = ".isDefault";
    public static final String PRIORITY_KEY = ".priority";
    public static final String SPIN_LIMIT_KEY = ".spinLimit";
    public static final String PARK_TIME_KEY = ".parkTime";
    private static final char KEY_IFS = ',';
    public static final int DEFAULT_PRIORITY = 5;
    public static final int DEFAULT_SPIN_LIMIT = 2500000;
    public static final int DEFAULT_PARK_TIME = 1000;
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final ThreadType DEFAULT_SELECTOR_TYPE = ThreadType.BLOCKING;
    private static final String DEFAULT_SELECTOR = "eBus:selectorThread:__DEFAULT__";
    private static SelectorInfo sDefaultSelector;
    private static Map<String, SelectorInfo> sSelectors;
    private static final Logger sLogger;

    private ENetConfigure() {
    }

    public static SelectorInfo defaultSelector() {
        return sDefaultSelector;
    }

    public static boolean isKnownSelector(String name) {
        return sSelectors.containsKey(name);
    }

    public static SelectorInfo selector(String name) {
        return sSelectors.get(name);
    }

    public static Map<String, SelectorInfo> selectors() {
        return sSelectors;
    }

    public static String asText() {
        String sep = "";
        Formatter retval = new Formatter();
        for (SelectorInfo info : sSelectors.values()) {
            retval.format("%s%s", sep, info);
            sep = "\\n";
        }
        return retval.toString();
    }

    public static void load(Properties props) throws MissingResourceException {
        ENetConfigure.load(new net.sf.eBus.util.Properties(props));
    }

    public static void load(net.sf.eBus.util.Properties props) throws MissingResourceException {
        String[] names;
        HashMap<String, SelectorInfo> selectors = new HashMap<String, SelectorInfo>();
        for (String name : names = props.getArrayProperty(SELECTORS_KEY, ',')) {
            if (selectors.containsKey(name)) {
                sLogger.warning(String.format("Selector %s appears twice in %s, ignored.", name, SELECTORS_KEY));
                continue;
            }
            selectors.put(name, ENetConfigure.loadInfo(name, props));
        }
        sSelectors = Collections.unmodifiableMap(selectors);
    }

    private static SelectorInfo loadInfo(String name, net.sf.eBus.util.Properties props) throws MissingResourceException {
        String keyPrefix = SELECTOR_PREFIX + name;
        long spinLimit = 0L;
        long parkTime = 0L;
        String key = keyPrefix + TYPE_KEY;
        String value = props.getProperty(key);
        ThreadType type = ThreadType.find(value);
        if (type == null) {
            throw new MissingResourceException(String.format("\"%s\" is not a valid selector type", value), ThreadType.class.getName(), key);
        }
        key = keyPrefix + DEFAULT_KEY;
        boolean defaultFlag = props.getBooleanProperty(key, false);
        key = keyPrefix + PRIORITY_KEY;
        int priority = props.getIntProperty(key, 5);
        if (priority < 1 || priority > 10) {
            throw new MissingResourceException(String.format("\"%s\" is not a valid thread priority", value), "int", key);
        }
        if ((type == ThreadType.SPINPARK || type == ThreadType.SPINYIELD) && (spinLimit = (long)props.getIntProperty(key = keyPrefix + SPIN_LIMIT_KEY, 2500000)) <= 0L) {
            throw new MissingResourceException(String.format("%,d is not a valid spin limit", spinLimit), Long.class.getName(), key);
        }
        if (type == ThreadType.SPINPARK && (parkTime = (long)props.getIntProperty(key = keyPrefix + PARK_TIME_KEY, 1000)) <= 0L) {
            throw new MissingResourceException(String.format("%,d is not a valid park time", spinLimit), Long.class.getName(), key);
        }
        return new SelectorInfo(name, type, defaultFlag, priority, spinLimit, parkTime);
    }

    static {
        sLogger = Logger.getLogger(ENetConfigure.class.getName());
        String configFile = System.getProperty("net.sf.eBus.config.file");
        sDefaultSelector = null;
        if (configFile != null && !configFile.isEmpty()) {
            try {
                net.sf.eBus.util.Properties props = net.sf.eBus.util.Properties.loadProperties((String)configFile);
                ENetConfigure.load(props);
                for (SelectorInfo sInfo : sSelectors.values()) {
                    if (!sInfo.isDefault()) continue;
                    sDefaultSelector = sInfo;
                    break;
                }
            }
            catch (IOException | IllegalArgumentException | MissingResourceException jex) {
                String reason = jex.getMessage();
                if (reason == null || reason.isEmpty()) {
                    reason = "(no reason given)";
                }
                sLogger.log(Level.WARNING, String.format("Error loading eBus network configuration from %s, %s.", configFile, reason), jex);
            }
        }
        if (sDefaultSelector == null) {
            sDefaultSelector = new SelectorInfo(DEFAULT_SELECTOR, DEFAULT_SELECTOR_TYPE, true, 5, 0L, 0L);
        }
        if (sSelectors == null) {
            HashMap<String, SelectorInfo> selectors = new HashMap<String, SelectorInfo>(1);
            selectors.put(sDefaultSelector.name(), sDefaultSelector);
            sSelectors = Collections.unmodifiableMap(selectors);
        }
    }

    public static final class SelectorInfo
    implements Comparable<SelectorInfo> {
        private final String mName;
        private final ThreadType mType;
        private final boolean mIsDefault;
        private final int mPriority;
        private final long mSpinLimit;
        private final long mParkTime;

        private SelectorInfo(String name, ThreadType type, boolean isDefault, int priority, long spinLimit, long parkTime) {
            this.mName = name;
            this.mType = type;
            this.mIsDefault = isDefault;
            this.mPriority = priority;
            this.mSpinLimit = spinLimit;
            this.mParkTime = parkTime;
        }

        @Override
        public int compareTo(SelectorInfo selector) {
            return this.mName.compareTo(selector.mName);
        }

        public String toString() {
            Formatter retval = new Formatter();
            retval.format("[%s]%n", this.mName);
            retval.format("selector type: %s%n", new Object[]{this.mType});
            retval.format("     priority: %s%n", this.mPriority);
            retval.format("   is default: %b%n", this.mIsDefault);
            if (this.mType == ThreadType.SPINPARK) {
                retval.format("   spin limit: %,d%n", this.mSpinLimit);
                retval.format("    park time: %,d nanoseconds%n", this.mParkTime);
            }
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public ThreadType type() {
            return this.mType;
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public int priority() {
            return this.mPriority;
        }

        public long spinLimit() {
            return this.mSpinLimit;
        }

        public long parkTime() {
            return this.mParkTime;
        }
    }
}

