/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.config;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javax.net.ssl.SSLContext;
import javax.swing.SwingUtilities;
import net.sf.eBus.config.AddressFilter;
import net.sf.eBus.config.ENetConfigure;
import net.sf.eBus.config.InetSocketAddressComparator;
import net.sf.eBus.config.ThreadType;

public final class EConfigure {
    public static final String CONFIG_FILE_ENV = "net.sf.eBus.config.file";
    public static final String SERVICES_KEY = "eBus.services";
    public static final String SERVICE_PREFIX = "eBus.service.";
    public static final String CONNECTIONS_KEY = "eBus.connections";
    public static final String CONNECTION_PREFIX = "eBus.connection.";
    public static final String DISPATCHERS_KEY = "eBus.dispatchers";
    public static final String DISPATCHER_PREFIX = "eBus.dispatcher.";
    public static final String PORT_KEY = ".port";
    public static final String INBUFFER_SIZE_KEY = ".inputBufferSize";
    public static final String OUTBUFFER_SIZE_KEY = ".outputBufferSize";
    public static final String BYTE_ORDER_KEY = ".byteOrder";
    public static final String MSG_QUEUE_SIZE_KEY = ".messageQueueSize";
    public static final String SVC_SELECTOR_KEY = ".serviceSelector";
    public static final String CONN_SELECTOR_KEY = ".connectionSelector";
    public static final String SELECTOR_KEY = ".selector";
    public static final String HOST_KEY = ".host";
    public static final String BIND_PORT_KEY = ".bindPort";
    public static final String RECONNECT_KEY = ".reconnect";
    public static final String RECONNECT_DELAY_KEY = ".reconnectTime";
    public static final String HB_DELAY_KEY = ".heartbeatDelay";
    public static final String HB_REPLY_DELAY_KEY = ".heartbeatReplyDelay";
    public static final String FILTER_KEY = ".addressFilter";
    public static final String DEFAULT_KEY = ".isDefault";
    public static final String DISPATCHER_TYPE_KEY = ".dispatcherType";
    public static final String THREAD_TYPE_KEY = ".runQueueType";
    public static final String SPIN_LIMIT_KEY = ".spinLimit";
    public static final String PARK_TIME_KEY = ".parkTime";
    public static final String PRIORITY_KEY = ".priority";
    public static final String QUANTUM_KEY = ".quantum";
    public static final String CLASSES_KEY = ".classes";
    public static final String NUM_THREADS_KEY = ".numberThreads";
    private static final char KEY_IFS = ',';
    private static final String KEY_SEP = ",";
    private static final String BIGENDIAN = "BIG_ENDIAN";
    private static final String LITTLEENDIAN = "LITTLE_ENDIAN";
    public static final String DEFAULT_THREAD_TYPE = ThreadType.BLOCKING.textName();
    public static final int DEFAULT_SPIN_LIMIT = 2500000;
    public static final int DEFAULT_PARK_TIME = 1000;
    public static final int DEFAULT_PRIORITY = 5;
    public static final int DEFAULT_QUANTUM = 500000;
    public static final int DEFAULT_NUMBER_THREADS = 4;
    public static final int DEFAULT_QUEUE_SIZE = 0;
    public static final boolean DEFAULT_RECONNECT_FLAG = false;
    public static final long DEFAULT_RECONNECT_TIME = 5000L;
    public static final long DEFAULT_HEARTBEAT_DELAY = 0L;
    public static final long DEFAULT_HEARTBEAT_REPLY_DELAY = 0L;
    private final Map<String, Service> mServices;
    private final Map<String, RemoteConnection> mRemoteConnections;
    private final Map<String, Dispatcher> mDispatchers;

    private EConfigure(Map<String, Service> services, Map<String, RemoteConnection> conns, Map<String, Dispatcher> dispatchers) {
        this.mServices = services;
        this.mRemoteConnections = conns;
        this.mDispatchers = dispatchers;
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof EConfigure) {
            EConfigure config = (EConfigure)o;
            retcode = this.mServices.equals(config.mServices) && this.mRemoteConnections.equals(config.mRemoteConnections);
        }
        return retcode;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        Formatter retval = new Formatter();
        retval.format("         services:", new Object[0]);
        if (this.mServices.isEmpty()) {
            retval.format("none%n", new Object[0]);
        } else {
            this.mServices.values().stream().forEach(service -> retval.format("%n    %s%n", service));
        }
        retval.format("       connections:", new Object[0]);
        if (this.mRemoteConnections.isEmpty()) {
            retval.format(" none%n", new Object[0]);
        } else {
            this.mRemoteConnections.values().stream().forEach(conn -> retval.format("%n    %s", conn));
        }
        return retval.toString();
    }

    public boolean hasServices() {
        return !this.mServices.isEmpty();
    }

    public Map<String, Service> services() {
        return this.mServices;
    }

    public boolean hasRemoteConnections() {
        return !this.mRemoteConnections.isEmpty();
    }

    public Map<String, RemoteConnection> remoteConnections() {
        return this.mRemoteConnections;
    }

    public Map<String, Dispatcher> dispatchers() {
        return this.mDispatchers;
    }

    public static EConfigure create(Map<String, Service> services, Map<String, RemoteConnection> connections, Map<String, Dispatcher> dispatchers) {
        return new EConfigure(services, connections, dispatchers);
    }

    public static ServerBuilder serverBuilder() {
        return new ServerBuilder();
    }

    public static ConnectionBuilder connectionBuilder() {
        return new ConnectionBuilder();
    }

    public static DispatcherBuilder dispatcherBuilder() {
        return new DispatcherBuilder();
    }

    public static EConfigure load(Properties props) {
        return new EConfigure(EConfigure.loadServices(props), EConfigure.loadConnections(props), EConfigure.loadDispatchers(props));
    }

    public static Map<String, Service> loadServices(Properties props) {
        net.sf.eBus.util.Properties p = EConfigure.properties(props);
        String[] names = p.getArrayProperty(SERVICES_KEY, ',');
        HashMap<String, Service> retval = new HashMap<String, Service>();
        for (String name : names) {
            String keyPrefix = SERVICE_PREFIX + name;
            ServerBuilder builder = new ServerBuilder();
            builder.name(name).connectionType(ConnectionType.TCP);
            String key = keyPrefix + PORT_KEY;
            builder.port(EConfigure.getPort(key, 0, p));
            key = keyPrefix + FILTER_KEY;
            builder.addressFilter(EConfigure.getFilter(key, p));
            key = keyPrefix + INBUFFER_SIZE_KEY;
            builder.inputBufferSize(EConfigure.getSize(key, 2048, 0, p));
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            builder.outputBufferSize(EConfigure.getSize(key, 2048, 0, p));
            key = keyPrefix + BYTE_ORDER_KEY;
            builder.byteOrder(EConfigure.getByteOrder(key, ByteOrder.LITTLE_ENDIAN, p));
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            builder.messageQueueSize(EConfigure.getSize(key, 0, 0, p));
            key = keyPrefix + SVC_SELECTOR_KEY;
            builder.serviceSelector(p.getProperty(key, ENetConfigure.defaultSelector().name()));
            key = keyPrefix + CONN_SELECTOR_KEY;
            builder.connectionSelector(p.getProperty(key, ENetConfigure.defaultSelector().name()));
            key = keyPrefix + HB_DELAY_KEY;
            builder.heartbeatDelay(p.getIntProperty(key, 0));
            key = keyPrefix + HB_REPLY_DELAY_KEY;
            builder.heartbeatReplyDelay(p.getIntProperty(key, 0));
            retval.put(name, builder.build());
        }
        return retval;
    }

    public static Map<String, RemoteConnection> loadConnections(Properties props) {
        net.sf.eBus.util.Properties p = EConfigure.properties(props);
        String[] names = p.getArrayProperty(CONNECTIONS_KEY, ',');
        HashMap<String, RemoteConnection> retval = new HashMap<String, RemoteConnection>();
        for (String name : names) {
            String keyPrefix = CONNECTION_PREFIX + name;
            ConnectionBuilder builder = new ConnectionBuilder();
            builder.name(name).connectionType(ConnectionType.TCP).address(EConfigure.getAddress(name, keyPrefix, p)).bindPort(EConfigure.getPort(keyPrefix + BIND_PORT_KEY, -1, p)).inputBufferSize(EConfigure.getSize(keyPrefix + INBUFFER_SIZE_KEY, 2048, 0, p)).outputBufferSize(EConfigure.getSize(keyPrefix + OUTBUFFER_SIZE_KEY, 2048, 0, p)).byteOrder(EConfigure.getByteOrder(keyPrefix + BYTE_ORDER_KEY, ByteOrder.LITTLE_ENDIAN, p)).messageQueueSize(EConfigure.getSize(keyPrefix + MSG_QUEUE_SIZE_KEY, 0, 0, p)).selector(p.getProperty(keyPrefix + SELECTOR_KEY, ENetConfigure.defaultSelector().name()));
            String key = keyPrefix + RECONNECT_KEY;
            builder.reconnect(p.getBooleanProperty(key, false));
            if (!builder.reconnect()) {
                builder.reconnectDelay(0L);
            } else {
                key = keyPrefix + RECONNECT_DELAY_KEY;
                builder.reconnectDelay(EConfigure.getDelay(key, 5000, 0L, p));
            }
            builder.heartbeatDelay(p.getIntProperty(keyPrefix + HB_DELAY_KEY, 0)).heartbeatReplyDelay(p.getIntProperty(keyPrefix + HB_REPLY_DELAY_KEY, 0));
            retval.put(name, builder.build());
        }
        return retval;
    }

    public static Map<String, Dispatcher> loadDispatchers(Properties props) {
        net.sf.eBus.util.Properties p = EConfigure.properties(props);
        String[] names = p.getArrayProperty(DISPATCHERS_KEY, ',');
        HashMap<String, Dispatcher> retval = new HashMap<String, Dispatcher>();
        for (String name : names) {
            DispatcherBuilder builder = new DispatcherBuilder();
            builder.name(name);
            builder.dispatcherType(DispatcherType.findType(name));
            if (builder.dispatcherType().isSpecial()) {
                EConfigure.loadSpecialDispatcher(builder, p);
            } else {
                EConfigure.loadDispatcher(builder, p);
            }
            retval.put(name, builder.build());
        }
        return retval;
    }

    public static EConfigure load(Preferences prefs) {
        return new EConfigure(EConfigure.loadServices(prefs), EConfigure.loadConnections(prefs), EConfigure.loadDispatchers(prefs));
    }

    public static Map<String, Service> loadServices(Preferences p) {
        String[] names = p.get(SERVICES_KEY, "").split(KEY_SEP);
        HashMap<String, Service> retval = new HashMap<String, Service>();
        for (String name : names) {
            String keyPrefix = SERVICE_PREFIX + name;
            ServerBuilder builder = new ServerBuilder();
            builder.name(name).connectionType(ConnectionType.TCP);
            String key = keyPrefix + PORT_KEY;
            builder.port(EConfigure.getPort(key, 0, p));
            key = keyPrefix + FILTER_KEY;
            builder.addressFilter(EConfigure.getFilter(key, p));
            key = keyPrefix + INBUFFER_SIZE_KEY;
            builder.inputBufferSize(EConfigure.getSize(key, 2048, 0, p));
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            builder.outputBufferSize(EConfigure.getSize(key, 2048, 0, p));
            key = keyPrefix + BYTE_ORDER_KEY;
            builder.byteOrder(EConfigure.getByteOrder(key, ByteOrder.LITTLE_ENDIAN, p));
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            builder.messageQueueSize(EConfigure.getSize(key, 0, 0, p));
            key = keyPrefix + SVC_SELECTOR_KEY;
            builder.serviceSelector(p.get(key, ENetConfigure.defaultSelector().name()));
            key = keyPrefix + SELECTOR_KEY;
            builder.connectionSelector(p.get(key, ENetConfigure.defaultSelector().name()));
            key = keyPrefix + HB_DELAY_KEY;
            builder.heartbeatDelay(p.getLong(key, 0L));
            key = keyPrefix + HB_REPLY_DELAY_KEY;
            builder.heartbeatReplyDelay(p.getLong(key, 0L));
            retval.put(name, builder.build());
        }
        return retval;
    }

    public static Map<String, RemoteConnection> loadConnections(Preferences p) {
        String[] names = p.get(CONNECTIONS_KEY, "").split(KEY_SEP);
        HashMap<String, RemoteConnection> retval = new HashMap<String, RemoteConnection>();
        for (String name : names) {
            String keyPrefix = CONNECTION_PREFIX + name;
            ConnectionBuilder builder = new ConnectionBuilder();
            builder.name(name).connectionType(ConnectionType.TCP).address(EConfigure.getAddress(name, keyPrefix, p));
            String key = keyPrefix + BIND_PORT_KEY;
            builder.bindPort(EConfigure.getPort(key, -1, p));
            builder.inputBufferSize(EConfigure.getSize(keyPrefix + INBUFFER_SIZE_KEY, 2048, 0, p));
            builder.outputBufferSize(EConfigure.getSize(keyPrefix + OUTBUFFER_SIZE_KEY, 2048, 0, p));
            builder.byteOrder(EConfigure.getByteOrder(keyPrefix + BYTE_ORDER_KEY, ByteOrder.LITTLE_ENDIAN, p));
            builder.messageQueueSize(EConfigure.getSize(keyPrefix + MSG_QUEUE_SIZE_KEY, 0, 0, p));
            builder.selector(p.get(keyPrefix + SELECTOR_KEY, ENetConfigure.defaultSelector().name()));
            key = keyPrefix + RECONNECT_KEY;
            builder.reconnect(p.getBoolean(key, false));
            if (!builder.reconnect()) {
                builder.reconnectDelay(0L);
            } else {
                key = keyPrefix + RECONNECT_DELAY_KEY;
                builder.reconnectDelay(EConfigure.getDelay(key, 5000, 0L, p));
            }
            key = keyPrefix + HB_DELAY_KEY;
            builder.heartbeatDelay(p.getLong(key, 0L));
            key = keyPrefix + HB_REPLY_DELAY_KEY;
            builder.heartbeatReplyDelay(p.getLong(key, 0L));
            retval.put(name, builder.build());
        }
        return retval;
    }

    public static Map<String, Dispatcher> loadDispatchers(Preferences p) {
        String[] names = p.get(DISPATCHERS_KEY, "").split(KEY_SEP);
        HashMap<String, Dispatcher> retval = new HashMap<String, Dispatcher>();
        for (String name : names) {
            DispatcherBuilder builder = new DispatcherBuilder();
            builder.name(name);
            builder.dispatcherType(DispatcherType.findType(name));
            if (builder.dispatcherType().isSpecial()) {
                EConfigure.loadSpecialDispatcher(builder, p);
            } else {
                EConfigure.loadDispatcher(builder, p);
            }
            retval.put(name, builder.build());
        }
        return retval;
    }

    public void store(Properties props) {
        this.storeService(props);
        this.storeConnections(props);
        this.storeDispatchers(props);
    }

    public void store(Preferences prefs) {
        this.storeService(prefs);
        this.storeConnections(prefs);
        this.storeDispatchers(prefs);
    }

    private static net.sf.eBus.util.Properties properties(Properties props) {
        net.sf.eBus.util.Properties retval = props instanceof net.sf.eBus.util.Properties ? (net.sf.eBus.util.Properties)props : new net.sf.eBus.util.Properties(props);
        return retval;
    }

    private static void loadDispatcher(DispatcherBuilder builder, net.sf.eBus.util.Properties p) {
        String keyName = DISPATCHER_PREFIX + builder.name();
        String key = keyName + THREAD_TYPE_KEY;
        builder.threadType(ThreadType.find(p.getProperty(key, DEFAULT_THREAD_TYPE)));
        if (builder.threadType() == ThreadType.SPINPARK || builder.threadType() == ThreadType.SPINYIELD) {
            key = keyName + SPIN_LIMIT_KEY;
            builder.spinLimit(p.getIntProperty(key, 2500000));
        }
        if (builder.threadType() == ThreadType.SPINPARK) {
            key = keyName + PARK_TIME_KEY;
            builder.parkTime(p.getIntProperty(key, 1000));
        }
        key = keyName + PRIORITY_KEY;
        builder.priority(p.getIntProperty(key, 5));
        key = keyName + QUANTUM_KEY;
        builder.quantum(p.getIntProperty(key, 500000));
        key = keyName + NUM_THREADS_KEY;
        builder.numberThreads(p.getIntProperty(key, 4));
        key = keyName + DEFAULT_KEY;
        builder.isDefault(p.getBooleanProperty(key, false));
        if (builder.isDefault()) {
            builder.classes(new Class[0]);
        } else {
            key = keyName + CLASSES_KEY;
            builder.classes(EConfigure.getClasses(key, p));
        }
    }

    private static void loadSpecialDispatcher(DispatcherBuilder builder, net.sf.eBus.util.Properties p) {
        String keyName = DISPATCHER_PREFIX + builder.name();
        String key = keyName + DEFAULT_KEY;
        builder.isDefault(p.getBooleanProperty(key, false));
        if (builder.isDefault()) {
            builder.classes(new Class[0]);
        } else {
            key = keyName + CLASSES_KEY;
            builder.classes(EConfigure.getClasses(key, p));
        }
        builder.threadType(ThreadType.BLOCKING).spinLimit(0L).parkTime(0L).priority(0).quantum(0L).numberThreads(0);
    }

    private static void loadDispatcher(DispatcherBuilder builder, Preferences p) {
        String keyName = DISPATCHER_PREFIX + builder.name();
        String key = keyName + THREAD_TYPE_KEY;
        builder.threadType(ThreadType.find(p.get(key, DEFAULT_THREAD_TYPE)));
        if (builder.threadType() == ThreadType.SPINPARK || builder.threadType() == ThreadType.SPINYIELD) {
            key = keyName + SPIN_LIMIT_KEY;
            builder.spinLimit(p.getInt(key, 2500000));
        }
        if (builder.threadType() == ThreadType.SPINPARK) {
            key = keyName + PARK_TIME_KEY;
            builder.parkTime(p.getInt(key, 1000));
        }
        key = keyName + PRIORITY_KEY;
        builder.priority(p.getInt(key, 5));
        key = keyName + QUANTUM_KEY;
        builder.quantum(p.getInt(key, 500000));
        key = keyName + NUM_THREADS_KEY;
        builder.numberThreads(p.getInt(key, 4));
        key = keyName + DEFAULT_KEY;
        builder.isDefault(p.getBoolean(key, false));
        if (builder.isDefault()) {
            builder.classes(new Class[0]);
        } else {
            builder.classes(EConfigure.getClasses(key, p));
        }
    }

    private static void loadSpecialDispatcher(DispatcherBuilder builder, Preferences p) {
        String keyName = DISPATCHER_PREFIX + builder.name();
        String key = keyName + DEFAULT_KEY;
        builder.isDefault(p.getBoolean(key, false));
        if (builder.isDefault()) {
            builder.classes(new Class[0]);
        } else {
            builder.classes(EConfigure.getClasses(key, p));
        }
        builder.threadType(ThreadType.BLOCKING).spinLimit(0L).parkTime(0L).priority(0).quantum(0L).numberThreads(0);
    }

    private static int getPort(String key, int defaultPort, net.sf.eBus.util.Properties p) {
        int retval = p.getIntProperty(key, defaultPort);
        if (retval < 0 && retval != -1 || retval > 65535) {
            throw new IllegalStateException(key + " invalid port (" + Integer.toString(retval) + ")");
        }
        return retval;
    }

    private static int getPort(String key, int defaultPort, Preferences p) {
        int retval = p.getInt(key, defaultPort);
        if (retval < 0 && retval != -1 || retval > 65535) {
            throw new IllegalStateException(key + " invalid port (" + Integer.toString(retval) + ")");
        }
        return retval;
    }

    private static AddressFilter getFilter(String key, net.sf.eBus.util.Properties p) {
        AddressFilter retval;
        try {
            retval = AddressFilter.parse(p.getProperty(key));
        }
        catch (ParseException parsex) {
            throw new IllegalStateException(parsex);
        }
        return retval;
    }

    private static AddressFilter getFilter(String key, Preferences p) {
        AddressFilter retval;
        try {
            retval = AddressFilter.parse(p.get(key, null));
        }
        catch (ParseException parsex) {
            throw new IllegalStateException(parsex);
        }
        return retval;
    }

    private static InetSocketAddress getAddress(String name, String keyPrefix, net.sf.eBus.util.Properties p) {
        InetSocketAddress retval;
        String key = keyPrefix + HOST_KEY;
        String host = p.getProperty(key);
        if (host == null || host.isEmpty()) {
            throw new MissingResourceException(name + " missing host", InetSocketAddress.class.getName(), key);
        }
        key = keyPrefix + PORT_KEY;
        int port = EConfigure.getPort(key, -1, p);
        try {
            retval = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException jex) {
            throw new IllegalStateException(name + " invalid address \"" + host + "\"", jex);
        }
        return retval;
    }

    private static InetSocketAddress getAddress(String name, String keyPrefix, Preferences p) {
        InetSocketAddress retval;
        String key = keyPrefix + HOST_KEY;
        String host = p.get(key, null);
        if (host == null || host.length() == 0) {
            throw new MissingResourceException(name + " missing host", InetSocketAddress.class.getName(), key);
        }
        key = keyPrefix + PORT_KEY;
        int port = EConfigure.getPort(key, -1, p);
        try {
            retval = new InetSocketAddress(InetAddress.getByName(host), port);
        }
        catch (UnknownHostException jex) {
            throw new IllegalStateException(name + " invalid address \"" + host + "\"", jex);
        }
        return retval;
    }

    private static int getSize(String key, int defaultValue, int minValue, net.sf.eBus.util.Properties p) {
        int retval = p.getIntProperty(key, defaultValue);
        if (retval < minValue) {
            throw new IllegalStateException(String.format("%s < %,d", key, minValue));
        }
        return retval;
    }

    private static int getSize(String key, int defaultValue, int minValue, Preferences p) {
        int retval = p.getInt(key, defaultValue);
        if (retval < minValue) {
            throw new IllegalStateException(key + " < " + Integer.toString(minValue));
        }
        return retval;
    }

    private static ByteOrder getByteOrder(String key, ByteOrder defaultValue, net.sf.eBus.util.Properties p) {
        ByteOrder retval;
        String value = p.getProperty(key);
        if (BIGENDIAN.equalsIgnoreCase(value)) {
            retval = ByteOrder.BIG_ENDIAN;
        } else if (LITTLEENDIAN.equalsIgnoreCase(value)) {
            retval = ByteOrder.LITTLE_ENDIAN;
        } else if (value == null || value.isEmpty()) {
            retval = defaultValue;
        } else {
            throw new IllegalStateException(String.format("%s value \"%s\" is invalid", key, value));
        }
        return retval;
    }

    private static ByteOrder getByteOrder(String key, ByteOrder defaultValue, Preferences p) {
        ByteOrder retval;
        String value = p.get(key, null);
        if (BIGENDIAN.equalsIgnoreCase(value)) {
            retval = ByteOrder.BIG_ENDIAN;
        } else if (LITTLEENDIAN.equalsIgnoreCase(value)) {
            retval = ByteOrder.LITTLE_ENDIAN;
        } else if (value == null || value.isEmpty()) {
            retval = defaultValue;
        } else {
            throw new IllegalStateException(String.format("%s value \"%s\" invalid", key, value));
        }
        return retval;
    }

    private static long getDelay(String key, int defaultValue, long minValue, net.sf.eBus.util.Properties p) {
        long retval = p.getIntProperty(key, defaultValue);
        if (retval < minValue) {
            throw new IllegalStateException("negative " + key);
        }
        return retval;
    }

    private static long getDelay(String key, int defaultValue, long minValue, Preferences p) {
        long retval = p.getInt(key, defaultValue);
        if (retval < minValue) {
            throw new IllegalStateException("negative " + key);
        }
        return retval;
    }

    private static Class<?>[] getClasses(String key, net.sf.eBus.util.Properties p) {
        String[] classNames = p.getArrayProperty(key, ',');
        int size = classNames.length;
        if (size == 0) {
            throw new MissingResourceException(String.format("%s missing or empty", key), Class.class.getName(), key);
        }
        Class[] retval = new Class[size];
        for (int index = 0; index < size; ++index) {
            try {
                retval[index] = Class.forName(classNames[index]);
                continue;
            }
            catch (ClassNotFoundException jex) {
                throw new MissingResourceException(String.format("unknown class %s", classNames[index]), Class.class.getName(), key);
            }
        }
        return retval;
    }

    private static Class<?>[] getClasses(String key, Preferences p) {
        String[] classNames = p.get(key, "").split(KEY_SEP);
        int size = classNames.length;
        if (size == 0) {
            throw new MissingResourceException(String.format("%s missing or empty", key), Class.class.getName(), key);
        }
        Class[] retval = new Class[size];
        for (int index = 0; index < size; ++index) {
            try {
                retval[index] = Class.forName(classNames[index]);
                continue;
            }
            catch (ClassNotFoundException jex) {
                throw new MissingResourceException(String.format("unknown class %s", classNames[index]), Class.class.getName(), key);
            }
        }
        return retval;
    }

    private void storeService(Properties p) {
        Formatter names = new Formatter();
        String sep = "";
        for (Service service : this.mServices.values()) {
            String name = service.name();
            String keyPrefix = SERVICE_PREFIX + name;
            AddressFilter filter = service.addressFilter();
            names.format("%s%s", sep, name);
            String key = keyPrefix + PORT_KEY;
            p.setProperty(key, Integer.toString(service.port()));
            key = keyPrefix + FILTER_KEY;
            p.setProperty(key, filter == null ? "" : filter.toString());
            key = keyPrefix + BYTE_ORDER_KEY;
            p.setProperty(key, service.byteOrder().toString());
            key = keyPrefix + INBUFFER_SIZE_KEY;
            p.setProperty(key, Integer.toString(service.inputBufferSize()));
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            p.setProperty(key, Integer.toString(service.outputBufferSize()));
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            p.setProperty(key, Integer.toString(service.messageQueueSize()));
        }
        p.setProperty(SERVICES_KEY, names.toString());
    }

    private void storeConnections(Properties p) {
        Formatter names = new Formatter();
        String sep = "";
        for (RemoteConnection connection : this.mRemoteConnections.values()) {
            String name = connection.name();
            String keyPrefix = CONNECTION_PREFIX + name;
            InetSocketAddress address = connection.address();
            names.format("%s%s", sep, name);
            String key = keyPrefix + HOST_KEY;
            p.setProperty(key, address.getHostName());
            key = keyPrefix + PORT_KEY;
            p.setProperty(key, Integer.toString(address.getPort()));
            key = keyPrefix + BIND_PORT_KEY;
            p.setProperty(key, Integer.toString(connection.bindPort()));
            key = keyPrefix + BYTE_ORDER_KEY;
            p.setProperty(key, connection.byteOrder().toString());
            key = keyPrefix + INBUFFER_SIZE_KEY;
            p.setProperty(key, Integer.toString(connection.inputBufferSize()));
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            p.setProperty(key, Integer.toString(connection.outputBufferSize()));
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            p.setProperty(key, Integer.toString(connection.messageQueueSize()));
            key = keyPrefix + RECONNECT_KEY;
            p.setProperty(key, Boolean.toString(connection.reconnectFlag()));
            key = keyPrefix + RECONNECT_DELAY_KEY;
            p.setProperty(key, Long.toString(connection.reconnectTime()));
            sep = KEY_SEP;
        }
        p.setProperty(CONNECTIONS_KEY, names.toString());
    }

    private void storeDispatchers(Properties p) {
        Formatter names = new Formatter();
        String sep = "";
        for (Dispatcher dispatcher : this.mDispatchers.values()) {
            String name = dispatcher.name();
            String keyPrefix = DISPATCHER_PREFIX + name;
            names.format("%s%s", sep, name);
            String key = keyPrefix + DEFAULT_KEY;
            p.setProperty(key, Boolean.toString(dispatcher.isDefault()));
            key = keyPrefix + PRIORITY_KEY;
            p.setProperty(key, String.valueOf(dispatcher.priority()));
            key = keyPrefix + QUANTUM_KEY;
            p.setProperty(key, Long.toString(dispatcher.quantum()));
            key = keyPrefix + NUM_THREADS_KEY;
            p.setProperty(key, Integer.toString(dispatcher.numberThreads()));
            sep = KEY_SEP;
        }
        p.setProperty(DISPATCHERS_KEY, names.toString());
    }

    private void storeService(Preferences p) {
        Formatter names = new Formatter();
        String sep = "";
        for (Service service : this.mServices.values()) {
            String name = service.name();
            String keyPrefix = SERVICE_PREFIX + name;
            AddressFilter filter = service.addressFilter();
            names.format("%s%s", sep, name);
            String key = keyPrefix + PORT_KEY;
            p.putInt(key, service.port());
            key = keyPrefix + FILTER_KEY;
            p.put(key, filter == null ? "" : filter.toString());
            key = keyPrefix + INBUFFER_SIZE_KEY;
            p.putInt(key, service.inputBufferSize());
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            p.putInt(key, service.outputBufferSize());
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            p.putInt(key, service.messageQueueSize());
        }
        p.put(SERVICES_KEY, names.toString());
    }

    private void storeConnections(Preferences p) {
        Formatter names = new Formatter();
        String sep = "";
        for (RemoteConnection connection : this.mRemoteConnections.values()) {
            String name = connection.name();
            String keyPrefix = CONNECTION_PREFIX + name;
            InetSocketAddress address = connection.address();
            names.format("%s%s", sep, name);
            String key = keyPrefix + HOST_KEY;
            p.put(key, address.getHostName());
            key = keyPrefix + PORT_KEY;
            p.putInt(key, address.getPort());
            key = keyPrefix + BIND_PORT_KEY;
            p.putInt(key, connection.bindPort());
            key = keyPrefix + INBUFFER_SIZE_KEY;
            p.putInt(key, connection.inputBufferSize());
            key = keyPrefix + OUTBUFFER_SIZE_KEY;
            p.putInt(key, connection.outputBufferSize());
            key = keyPrefix + MSG_QUEUE_SIZE_KEY;
            p.putInt(key, connection.messageQueueSize());
            key = keyPrefix + RECONNECT_KEY;
            p.putBoolean(key, connection.reconnectFlag());
            key = keyPrefix + RECONNECT_DELAY_KEY;
            p.putLong(key, connection.reconnectTime());
            sep = KEY_SEP;
        }
        p.put(CONNECTIONS_KEY, names.toString());
    }

    private void storeDispatchers(Preferences p) {
        Formatter names = new Formatter();
        String sep = "";
        for (Dispatcher dispatcher : this.mDispatchers.values()) {
            String name = dispatcher.name();
            String keyPrefix = DISPATCHER_PREFIX + name;
            names.format("%s%s", sep, name);
            String key = keyPrefix + DEFAULT_KEY;
            p.putBoolean(key, dispatcher.isDefault());
            key = keyPrefix + PRIORITY_KEY;
            p.putInt(key, dispatcher.priority());
            key = keyPrefix + QUANTUM_KEY;
            p.putLong(key, dispatcher.quantum());
            key = keyPrefix + NUM_THREADS_KEY;
            p.putInt(key, dispatcher.numberThreads());
            sep = KEY_SEP;
        }
        p.put(DISPATCHERS_KEY, names.toString());
    }

    public static final class DispatcherBuilder {
        private String mName = null;
        private DispatcherType mType = null;
        private ThreadType mRunQueueType = null;
        private long mSpinLimit = 0L;
        private long mParkTime = 0L;
        private int mPriority = 5;
        private long mQuantum = 500000L;
        private int mNumThreads = 4;
        private boolean mIsDefault = false;
        private Class<?>[] mClasses = new Class[0];

        private DispatcherBuilder() {
        }

        public String name() {
            return this.mName;
        }

        public DispatcherType dispatcherType() {
            return this.mType;
        }

        public ThreadType threadType() {
            return this.mRunQueueType;
        }

        public long spinLimit() {
            return this.mSpinLimit;
        }

        public long parkTime() {
            return this.mParkTime;
        }

        public int priority() {
            return this.mPriority;
        }

        public long quantum() {
            return this.mQuantum;
        }

        public int numberThreads() {
            return this.mNumThreads;
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public Class<?>[] classes() {
            return Arrays.copyOf(this.mClasses, this.mClasses.length);
        }

        public DispatcherBuilder name(String name) {
            Objects.requireNonNull(name, "name is null");
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            this.mName = name;
            return this;
        }

        public DispatcherBuilder dispatcherType(DispatcherType type) {
            this.mType = Objects.requireNonNull(type, "dispatcher type is null");
            return this;
        }

        public DispatcherBuilder threadType(ThreadType type) {
            this.mRunQueueType = Objects.requireNonNull(type, "thread type is null");
            return this;
        }

        public DispatcherBuilder spinLimit(long limit) {
            if (limit < 0L) {
                throw new IllegalArgumentException("limit < zero");
            }
            this.mSpinLimit = limit;
            return this;
        }

        public DispatcherBuilder parkTime(long time) {
            if (time < 0L) {
                throw new IllegalArgumentException("time < zero");
            }
            this.mParkTime = time;
            return this;
        }

        public DispatcherBuilder priority(int priority) {
            if (priority < 0 || priority > 10) {
                throw new IllegalArgumentException("priority out of bounds");
            }
            this.mPriority = priority;
            return this;
        }

        public DispatcherBuilder quantum(long quantum) {
            if (quantum < 0L) {
                throw new IllegalArgumentException("quantum < zero");
            }
            this.mQuantum = quantum;
            return this;
        }

        public DispatcherBuilder numberThreads(int numThreads) {
            if (numThreads < 0) {
                throw new IllegalArgumentException("numThreads < zero");
            }
            this.mNumThreads = numThreads;
            return this;
        }

        public DispatcherBuilder isDefault(boolean flag) {
            this.mIsDefault = flag;
            return this;
        }

        public DispatcherBuilder classes(Class<?>[] classes) {
            this.mClasses = classes == null ? new Class[0] : Arrays.copyOf(classes, classes.length);
            return this;
        }

        public Dispatcher build() {
            this.validate();
            return new Dispatcher(this);
        }

        private void validate() {
            Objects.requireNonNull(this.mName, "name is null");
            Objects.requireNonNull(this.mType, "dispatcher type not set");
            Objects.requireNonNull(this.mRunQueueType, "thread type not set");
            if (this.mRunQueueType == ThreadType.SPINPARK) {
                if (this.mSpinLimit <= 0L) {
                    throw new IllegalArgumentException("spin limit not set for spin+park thread type");
                }
                if (this.mParkTime <= 0L) {
                    throw new IllegalArgumentException("park limit not set for spin+park thread type");
                }
            } else if (this.mRunQueueType == ThreadType.SPINYIELD && this.mSpinLimit <= 0L) {
                throw new IllegalArgumentException("spin limit not set for spin+yield thread type");
            }
            if (!(this.mIsDefault || this.mClasses != null && this.mClasses.length != 0)) {
                throw new IllegalArgumentException("classes not set for non-default dispatcher");
            }
        }
    }

    public static final class ConnectionBuilder
    extends AbstractBuilder {
        private InetSocketAddress mAddress = null;
        private int mBindPort = -1;
        private String mSelector = ENetConfigure.defaultSelector().name();
        private boolean mReconnectFlag = false;
        private long mReconnectTime = 0L;

        private ConnectionBuilder() {
        }

        public InetSocketAddress address() {
            return this.mAddress;
        }

        public int bindPort() {
            return this.mBindPort;
        }

        public String selector() {
            return this.mSelector;
        }

        public boolean reconnect() {
            return this.mReconnectFlag;
        }

        public long reconnectDelay() {
            return this.mReconnectTime;
        }

        public ConnectionBuilder name(String name) {
            this.setName(name);
            return this;
        }

        public ConnectionBuilder connectionType(ConnectionType connType) {
            this.setConnectionType(connType);
            return this;
        }

        public ConnectionBuilder address(InetSocketAddress address) {
            Objects.requireNonNull(address, "address is null");
            this.mAddress = address;
            return this;
        }

        public ConnectionBuilder bindPort(int port) {
            if (port < -1 || port > 65535) {
                throw new IllegalArgumentException("invalid bind port (" + port + ")");
            }
            this.mBindPort = port;
            return this;
        }

        public ConnectionBuilder inputBufferSize(int size) {
            this.setInputBufferSize(size);
            return this;
        }

        public ConnectionBuilder outputBufferSize(int size) {
            this.setOutputBufferSize(size);
            return this;
        }

        public ConnectionBuilder byteOrder(ByteOrder byteOrder) {
            this.setByteOrder(byteOrder);
            return this;
        }

        public ConnectionBuilder messageQueueSize(int size) {
            this.setMessageQueueSize(size);
            return this;
        }

        public ConnectionBuilder selector(String selector) {
            Objects.requireNonNull(selector, "selector is null");
            if (selector.isEmpty()) {
                throw new IllegalArgumentException("selector is empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new IllegalArgumentException("\"" + selector + "\" unknown selector");
            }
            this.mSelector = selector;
            return this;
        }

        public ConnectionBuilder reconnect(boolean flag) {
            this.mReconnectFlag = flag;
            return this;
        }

        public ConnectionBuilder reconnectDelay(long time) {
            if (time < 0L) {
                throw new IllegalArgumentException("reconnect time < 0");
            }
            this.mReconnectTime = time;
            return this;
        }

        public ConnectionBuilder heartbeatDelay(long delay) {
            this.setHeartbeatDelay(delay);
            return this;
        }

        public ConnectionBuilder heartbeatReplyDelay(long delay) {
            this.setHeartbeatReplyDelay(delay);
            return this;
        }

        public ConnectionBuilder sslContext(SSLContext context) {
            this.setSSLContext(context);
            return this;
        }

        public RemoteConnection build() {
            this.validate();
            return new RemoteConnection(this);
        }

        @Override
        protected void validate() {
            super.validate();
            Objects.requireNonNull(this.mName, "connection name not set");
            Objects.requireNonNull(this.mAddress, "address not set");
            if (this.mReconnectFlag && this.mReconnectTime <= 0L) {
                throw new IllegalArgumentException("reconnect time == 0");
            }
        }
    }

    public static final class ServerBuilder
    extends AbstractBuilder {
        private int mPort = 0;
        private AddressFilter mAddressFilter = null;
        private String mServiceSelector;
        private String mConnSelector = this.mServiceSelector = ENetConfigure.defaultSelector().name();

        private ServerBuilder() {
        }

        public int port() {
            return this.mPort;
        }

        public AddressFilter addressFilter() {
            return this.mAddressFilter;
        }

        public String serviceSelector() {
            return this.mServiceSelector;
        }

        public String connectionSelector() {
            return this.mConnSelector;
        }

        public ServerBuilder name(String name) {
            this.setName(name);
            return this;
        }

        public ServerBuilder connectionType(ConnectionType connType) {
            this.setConnectionType(connType);
            return this;
        }

        public ServerBuilder port(int port) {
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("invalid port (" + port + ")");
            }
            this.mPort = port;
            return this;
        }

        public ServerBuilder addressFilter(AddressFilter filter) {
            this.mAddressFilter = filter;
            return this;
        }

        public ServerBuilder inputBufferSize(int size) {
            this.setInputBufferSize(size);
            return this;
        }

        public ServerBuilder outputBufferSize(int size) {
            this.setOutputBufferSize(size);
            return this;
        }

        public ServerBuilder byteOrder(ByteOrder byteOrder) {
            this.setByteOrder(byteOrder);
            return this;
        }

        public ServerBuilder messageQueueSize(int size) {
            this.setMessageQueueSize(size);
            return this;
        }

        public ServerBuilder serviceSelector(String selector) {
            Objects.requireNonNull(selector, "service selector is null");
            if (selector.isEmpty()) {
                throw new IllegalArgumentException("service selector is empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new IllegalArgumentException("\"" + selector + "\" unknown service selector");
            }
            this.mServiceSelector = selector;
            return this;
        }

        public ServerBuilder connectionSelector(String selector) {
            Objects.requireNonNull(selector, "connection selector is null");
            if (selector.isEmpty()) {
                throw new IllegalArgumentException("connection selector is empty");
            }
            if (!ENetConfigure.isKnownSelector(selector)) {
                throw new IllegalArgumentException("\"" + selector + "\" unknown connection selector");
            }
            this.mConnSelector = selector;
            return this;
        }

        public ServerBuilder heartbeatDelay(long delay) {
            this.setHeartbeatDelay(delay);
            return this;
        }

        public ServerBuilder heartbeatReplyDelay(long delay) {
            this.setHeartbeatReplyDelay(delay);
            return this;
        }

        public ServerBuilder sslContext(SSLContext context) {
            this.setSSLContext(context);
            return this;
        }

        public Service build() {
            this.validate();
            return new Service(this);
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.mPort == 0) {
                throw new IllegalArgumentException("service port not set");
            }
        }
    }

    public static abstract class AbstractBuilder {
        protected String mName = null;
        private ConnectionType mConnectionType = ConnectionType.TCP;
        protected int mInputBufferSize = 0;
        protected int mOutputBufferSize = 0;
        protected ByteOrder mByteOrder = ByteOrder.LITTLE_ENDIAN;
        protected int mMsgQueueSize = 0;
        protected long mHbDelay = 0L;
        protected long mHbReplyDelay = 0L;
        protected SSLContext mSSLContext = null;

        protected AbstractBuilder() {
        }

        public final String name() {
            return this.mName;
        }

        public final ConnectionType connectionType() {
            return this.mConnectionType;
        }

        public final int inputBufferSize() {
            return this.mInputBufferSize;
        }

        public final int outputBufferSize() {
            return this.mOutputBufferSize;
        }

        public final ByteOrder byteOrder() {
            return this.mByteOrder;
        }

        public final int messageQueueSize() {
            return this.mMsgQueueSize;
        }

        public final long heartbeatDelay() {
            return this.mHbDelay;
        }

        public final long heartbeatReplyDelay() {
            return this.mHbReplyDelay;
        }

        public final SSLContext sslContext() {
            return this.mSSLContext;
        }

        protected final void setName(String name) {
            Objects.requireNonNull(name, "name is null");
            if (name.isEmpty()) {
                throw new IllegalArgumentException("name is empty");
            }
            this.mName = name;
        }

        protected final void setConnectionType(ConnectionType connType) {
            this.mConnectionType = Objects.requireNonNull(connType, "connType is null");
        }

        protected final void setInputBufferSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("input buffer size < 0");
            }
            this.mInputBufferSize = size;
        }

        protected final void setOutputBufferSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("output buffer size < 0");
            }
            this.mOutputBufferSize = size;
        }

        protected final void setByteOrder(ByteOrder byteOrder) {
            Objects.requireNonNull(byteOrder, "byteOrder is null");
            this.mByteOrder = byteOrder;
        }

        protected final void setMessageQueueSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("message queue size < 0");
            }
            this.mMsgQueueSize = size;
        }

        protected final void setHeartbeatDelay(long delay) {
            if (delay < 0L) {
                throw new IllegalArgumentException("heartbeat delay < 0");
            }
            this.mHbDelay = delay;
        }

        protected final void setHeartbeatReplyDelay(long delay) {
            if (delay < 0L) {
                throw new IllegalArgumentException("heartbeat reply delay < 0");
            }
            this.mHbReplyDelay = delay;
        }

        protected final void setSSLContext(SSLContext context) {
            this.mSSLContext = Objects.requireNonNull(context, "context is null");
        }

        protected void validate() {
            Objects.requireNonNull(this.mName, "service name is null");
            Objects.requireNonNull(this.mConnectionType, "connection type is null");
            if (this.mConnectionType == ConnectionType.SECURE_TCP) {
                Objects.requireNonNull(this.mSSLContext, "SSL context not provided for secure connection");
            } else if (this.mSSLContext != null) {
                throw new IllegalArgumentException("SSL context provided for non-secure connection");
            }
        }
    }

    public static final class Dispatcher
    implements Comparable<Dispatcher> {
        private final String mName;
        private final DispatcherType mType;
        private final ThreadType mRunQueueType;
        private final long mSpinLimit;
        private final long mParkTime;
        private final int mPriority;
        private final long mQuantum;
        private final int mNumThreads;
        private final boolean mIsDefault;
        private final Class<?>[] mClasses;

        Dispatcher(DispatcherBuilder builder) {
            this.mName = builder.name();
            this.mType = builder.dispatcherType();
            this.mRunQueueType = builder.threadType();
            this.mSpinLimit = builder.spinLimit();
            this.mParkTime = builder.parkTime();
            this.mPriority = builder.priority();
            this.mQuantum = builder.quantum();
            this.mNumThreads = builder.numberThreads();
            this.mIsDefault = builder.isDefault();
            this.mClasses = builder.classes();
        }

        @Override
        public int compareTo(Dispatcher o) {
            return this.mName.compareTo(o.mName);
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode) {
                retcode = this.mName.equals(((Dispatcher)o).mName);
            }
            return retcode;
        }

        public int hashCode() {
            return this.mName.hashCode();
        }

        public String toString() {
            Formatter retval = new Formatter();
            retval.format("[%s]%n", this.mName);
            retval.format("       priority: %s%n", this.mPriority);
            retval.format("     is default: %b%n", this.mIsDefault);
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public DispatcherType dispatchType() {
            return this.mType;
        }

        public ThreadType runQueueType() {
            return this.mRunQueueType;
        }

        public long spinLimit() {
            return this.mSpinLimit;
        }

        public long parkTime() {
            return this.mParkTime;
        }

        public boolean isDefault() {
            return this.mIsDefault;
        }

        public Class<?>[] classes() {
            return Arrays.copyOf(this.mClasses, this.mClasses.length);
        }

        public int priority() {
            return this.mPriority;
        }

        public long quantum() {
            return this.mQuantum;
        }

        public int numberThreads() {
            return this.mNumThreads;
        }
    }

    public static final class RemoteConnection
    implements Comparable<RemoteConnection> {
        private final String mName;
        private final ConnectionType mConnectionType;
        private final InetSocketAddress mAddress;
        private final int mBindPort;
        private final int mInputBufferSize;
        private final int mOutputBufferSize;
        private final ByteOrder mByteOrder;
        private final int mMsgQueueSize;
        private final String mSelector;
        private final boolean mReconnectFlag;
        private final long mReconnectTime;
        private final long mHbDelay;
        private final long mHbReplyDelay;
        private final SSLContext mSSLContext;

        RemoteConnection(ConnectionBuilder builder) {
            this.mName = builder.name();
            this.mConnectionType = builder.connectionType();
            this.mAddress = builder.address();
            this.mBindPort = builder.bindPort();
            this.mInputBufferSize = builder.inputBufferSize();
            this.mOutputBufferSize = builder.outputBufferSize();
            this.mByteOrder = builder.byteOrder();
            this.mMsgQueueSize = builder.messageQueueSize();
            this.mSelector = builder.selector();
            this.mReconnectFlag = builder.reconnect();
            this.mReconnectTime = builder.reconnectDelay();
            this.mHbDelay = builder.heartbeatDelay();
            this.mHbReplyDelay = builder.heartbeatReplyDelay();
            this.mSSLContext = builder.sslContext();
        }

        @Override
        public int compareTo(RemoteConnection conn) {
            InetSocketAddressComparator comparator = new InetSocketAddressComparator();
            return comparator.compare(this.mAddress, conn.mAddress);
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof RemoteConnection) {
                retcode = this.mAddress.equals(((RemoteConnection)o).mAddress);
            }
            return retcode;
        }

        public int hashCode() {
            return this.mAddress.hashCode();
        }

        public String toString() {
            Formatter retval = new Formatter();
            retval.format("[%s] address: %s%n", this.mName, this.mAddress).format("     connection type: %s%n", new Object[]{this.mConnectionType}).format("           bind port: %d%n", this.mBindPort).format("   input buffer size: %,d%n", this.mInputBufferSize).format("  output buffer size: %,d%n", this.mOutputBufferSize).format("   buffer byte order: %s%n", this.mByteOrder).format("          queue size: %,d%n", this.mMsgQueueSize).format("            selector: %s%n", this.mSelector).format("           reconnect: %b%n", this.mReconnectFlag);
            if (this.mReconnectFlag) {
                retval.format("      reconnect time: %,d msecs%n", this.mReconnectTime);
            }
            if (this.mConnectionType == ConnectionType.SECURE_TCP) {
                retval.format("       SSL context: %s%n", this.mSSLContext);
            }
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public ConnectionType connectionType() {
            return this.mConnectionType;
        }

        public InetSocketAddress address() {
            return this.mAddress;
        }

        public int bindPort() {
            return this.mBindPort;
        }

        public int inputBufferSize() {
            return this.mInputBufferSize;
        }

        public int outputBufferSize() {
            return this.mOutputBufferSize;
        }

        public ByteOrder byteOrder() {
            return this.mByteOrder;
        }

        public int messageQueueSize() {
            return this.mMsgQueueSize;
        }

        public String selector() {
            return this.mSelector;
        }

        public boolean reconnectFlag() {
            return this.mReconnectFlag;
        }

        public long reconnectTime() {
            return this.mReconnectTime;
        }

        public long heartbeatDelay() {
            return this.mHbDelay;
        }

        public long heartbeatReplyDelay() {
            return this.mHbReplyDelay;
        }

        public SSLContext sslContext() {
            return this.mSSLContext;
        }
    }

    public static final class Service
    implements Comparable<Service> {
        private final String mName;
        private final ConnectionType mConnectionType;
        private final int mPort;
        private final AddressFilter mAddressFilter;
        private final int mInputBufferSize;
        private final int mOutputBufferSize;
        private final ByteOrder mByteOrder;
        private final int mMsgQueueSize;
        private final String mServiceSelector;
        private final String mConnSelector;
        private final long mHbDelay;
        private final long mHbReplyDelay;
        private final SSLContext mSSLContext;

        Service(ServerBuilder builder) {
            this.mName = builder.name();
            this.mConnectionType = builder.connectionType();
            this.mPort = builder.port();
            this.mAddressFilter = builder.addressFilter();
            this.mInputBufferSize = builder.inputBufferSize();
            this.mOutputBufferSize = builder.outputBufferSize();
            this.mByteOrder = builder.byteOrder();
            this.mMsgQueueSize = builder.messageQueueSize();
            this.mServiceSelector = builder.serviceSelector();
            this.mConnSelector = builder.connectionSelector();
            this.mHbDelay = builder.heartbeatDelay();
            this.mHbReplyDelay = builder.heartbeatReplyDelay();
            this.mSSLContext = builder.sslContext();
        }

        @Override
        public int compareTo(Service service) {
            return this.mPort - service.mPort;
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof Service) {
                Service svc = (Service)o;
                retcode = this.mConnectionType == svc.mConnectionType && this.mPort == svc.mPort;
            }
            return retcode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mConnectionType, this.mPort});
        }

        public String toString() {
            Formatter retval = new Formatter();
            retval.format("[%s %d]%n", new Object[]{this.mConnectionType, this.mPort}).format("address filter: %s%n", this.mAddressFilter).format("socket input size: %,d%n", this.mInputBufferSize).format("socket output size: %,d%n", this.mOutputBufferSize).format(" socket byte order: %s%n", this.mByteOrder).format("    max queue size: %,d", this.mMsgQueueSize).format("          selector: %s%n", this.mConnSelector);
            if (this.mConnectionType == ConnectionType.SECURE_TCP) {
                retval.format("       SSL context: %s%n", this.mSSLContext);
            }
            return retval.toString();
        }

        public String name() {
            return this.mName;
        }

        public ConnectionType connectionType() {
            return this.mConnectionType;
        }

        public int port() {
            return this.mPort;
        }

        public AddressFilter addressFilter() {
            return this.mAddressFilter;
        }

        public int inputBufferSize() {
            return this.mInputBufferSize;
        }

        public int outputBufferSize() {
            return this.mOutputBufferSize;
        }

        public ByteOrder byteOrder() {
            return this.mByteOrder;
        }

        public int messageQueueSize() {
            return this.mMsgQueueSize;
        }

        public String serviceSelector() {
            return this.mServiceSelector;
        }

        public String connectionSelector() {
            return this.mConnSelector;
        }

        public long heartbeatDelay() {
            return this.mHbDelay;
        }

        public long heartbeatReplyDelay() {
            return this.mHbReplyDelay;
        }

        public SSLContext sslContext() {
            return this.mSSLContext;
        }
    }

    public static enum DispatcherType {
        EBUS(false, null),
        JAVAFX(true, task -> {
            if (Platform.isFxApplicationThread()) {
                try {
                    task.run();
                }
                catch (Exception jex) {
                    System.err.println(jex.getLocalizedMessage());
                }
            } else {
                Platform.runLater((Runnable)task);
            }
        }),
        SWING(true, task -> {
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    task.run();
                }
                catch (Exception jex) {
                    System.err.println(jex.getLocalizedMessage());
                }
            } else {
                SwingUtilities.invokeLater(task);
            }
        });

        private final boolean _special;
        private final Consumer<Runnable> _dispatchHandle;

        private DispatcherType(boolean special, Consumer<Runnable> handle) {
            this._special = special;
            this._dispatchHandle = handle;
        }

        public boolean isSpecial() {
            return this._special;
        }

        public Consumer<Runnable> dispatchHandle() {
            return this._dispatchHandle;
        }

        public static DispatcherType findType(String name) {
            DispatcherType[] types = DispatcherType.values();
            int numTypes = types.length;
            DispatcherType retval = null;
            for (int index = 0; index < numTypes && retval == null; ++index) {
                if (!name.equalsIgnoreCase(types[index].name())) continue;
                retval = types[index];
            }
            if (retval == null) {
                retval = EBUS;
            }
            return retval;
        }
    }

    public static enum ConnectionType {
        TCP,
        SECURE_TCP;

    }
}

