/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later
 * version.
 *
 * This library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA
 * 02111-1307 USA
 *
 * The Initial Developer of the Original Code is Charles W. Rapp.
 * Portions created by Charles W. Rapp are
 * Copyright 2019. Charles W. Rapp
 * All Rights Reserved.
 */

/**
 * Provides classes needed to configure eBus network and eBus
 * core modules.
 * <p>
 * This configuration package provides the utility classes:
 * </p>
 * <ol>
 *   <li>
 *     {@link net.sf.eBus.config.AddressFilter} : provides
 *     ability to positively filter accepted connections.
 *     "Positive" means that the accepted connection must be from
 *     a host or host and port that is in the filter.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.config.InetAddressComparator}: provides
 *     comparison between two {@code java.net.InetAddress}
 *     instances.
 *   </li>
 *   <li>
 *     {@link net.sf.eBus.config.InetSocketAddressComparator}:
 *     provides comparison between two
 *     {@code java.net.InetSocketAddress} instances.
 *   </li>
 * </ol>
 */

package net.sf.eBus.config;
