/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doolin.oxml.adapter;

import java.lang.reflect.Method;
import net.sf.doolin.oxml.OXMLContext;
import net.sf.doolin.oxml.adapter.AbstractSimpleOXMLAdapter;
import net.sf.doolin.util.Utils;
import org.apache.commons.lang.StringUtils;

public class EnumOXMLAdapter
extends AbstractSimpleOXMLAdapter<Enum<?>> {
    private String type;

    @Override
    protected Enum<?> adapt(String value, OXMLContext context) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        try {
            Class ec = Utils.forClass((String)this.type);
            Method methodValueOf = ec.getMethod("valueOf", String.class);
            Object e = methodValueOf.invoke(null, value);
            return (Enum)e;
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot convert " + value + " to enumeration " + this.type, ex);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

