/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doolin.oxml.action;

import java.io.IOException;
import java.lang.reflect.Method;
import net.sf.doolin.oxml.OXMLContext;
import net.sf.doolin.oxml.OXMLFactory;
import net.sf.doolin.oxml.action.AbstractOXMLAction;
import net.sf.doolin.oxml.adapter.DefaultOXMLAdapter;
import net.sf.doolin.oxml.adapter.OXMLAdapter;
import net.sf.doolin.oxml.annotation.Collection;
import net.sf.doolin.util.Utils;
import net.sf.doolin.util.xml.DOMUtils;
import net.sf.jstring.LocalizableException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropertyOXMLAction
extends AbstractOXMLAction {
    private String node;
    private String name;
    private String value;
    private String setter;
    private OXMLAdapter adapter = new DefaultOXMLAdapter();

    @Override
    public void parse(Element e) throws IOException {
        Element eAdapter;
        this.name = DOMUtils.getAttribute((Element)e, (String)"name", (boolean)true, null);
        this.node = DOMUtils.getAttribute((Element)e, (String)"node", (boolean)false, null);
        this.value = DOMUtils.getAttribute((Element)e, (String)"value", (boolean)false, null);
        this.setter = DOMUtils.getAttribute((Element)e, (String)"setter", (boolean)false, null);
        if (this.value == null && StringUtils.isBlank((String)this.node)) {
            this.node = StringUtils.replace((String)this.name, (String)".", (String)"/");
        }
        if ((eAdapter = DOMUtils.getElement((Element)e, (String)"http://www.doolin-guif.net/schema/oxml", (String)"adapter")) != null) {
            this.adapter = (OXMLAdapter)OXMLFactory.getInstance().create(eAdapter);
        } else {
            Class adapterClass = DOMUtils.getClassAttribute((Element)e, (String)"adapter", null);
            if (adapterClass != null) {
                this.adapter = (OXMLAdapter)Utils.newInstance((Class)adapterClass);
            }
        }
    }

    @Override
    public void process(OXMLContext context) {
        if (this.value != null) {
            Object instance = context.instancePeek();
            try {
                this.setProperty(instance, this.value);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot set property " + this.name, ex);
            }
        }
        Node currentNode = context.nodePeek();
        Object instance = context.instancePeek();
        Object propertyValue = this.adapter.adapt(currentNode, this.node, context);
        if (propertyValue != null) {
            try {
                Collection collection;
                Class propertyType = PropertyUtils.getPropertyType((Object)instance, (String)this.name);
                if (propertyType.isEnum()) {
                    propertyValue = this.toEnum(instance, propertyValue);
                } else if (context.getConfig().isCollectEnabled() && (collection = (Collection)Utils.getPropertyAnnotation(Collection.class, (Object)instance, (String)this.name)) != null) {
                    String collectionName = collection.name();
                    if (StringUtils.isBlank((String)collectionName)) {
                        collectionName = this.name;
                    }
                    if (collection.beanName()) {
                        String beanClassName = instance.getClass().getName();
                        String beanName = StringUtils.substringAfterLast((String)beanClassName, (String)".");
                        collectionName = collectionName + "@" + beanName;
                    }
                    context.collect(collectionName, propertyValue);
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new LocalizableException("PropertyOXMLAction.PropertyInspectError", (Throwable)ex, new Object[]{this.name});
            }
        }
        try {
            if (propertyValue != null) {
                this.setProperty(instance, propertyValue);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot set property " + this.name, ex);
        }
    }

    protected void setProperty(Object instance, Object propertyValue) throws Exception {
        if (StringUtils.isBlank((String)this.setter)) {
            BeanUtils.setProperty((Object)instance, (String)this.name, (Object)propertyValue);
        } else {
            Object propertyHolder = Utils.getProperty((Object)instance, (String)this.name);
            Utils.callMethod((Object)propertyHolder, (String)this.setter, (Object[])new Object[]{propertyValue});
        }
    }

    protected Object toEnum(Object instance, Object propertyValue) {
        if (propertyValue != null) {
            try {
                Class propertyType = PropertyUtils.getPropertyType((Object)instance, (String)this.name);
                if (propertyType.isEnum()) {
                    Class enumClass = propertyType;
                    String propertyString = propertyValue.toString();
                    String propertyEnumString = StringUtils.upperCase((String)propertyString);
                    Method valueOfMethod = enumClass.getMethod("valueOf", String.class);
                    Enum enumValue = (Enum)valueOfMethod.invoke(null, propertyEnumString);
                    propertyValue = enumValue;
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new LocalizableException("PropertyOXMLAction.EnumConversionError", (Throwable)ex, new Object[]{propertyValue});
            }
        }
        return propertyValue;
    }
}

