/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doolin.oxml.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.doolin.oxml.action.CheckOXMLAction;
import net.sf.doolin.oxml.action.CreateDefOXMLAction;
import net.sf.doolin.oxml.action.CreateOXMLAction;
import net.sf.doolin.oxml.action.ForOXMLAction;
import net.sf.doolin.oxml.action.IfOXMLAction;
import net.sf.doolin.oxml.action.IncludeOXMLAction;
import net.sf.doolin.oxml.action.OXMLAction;
import net.sf.doolin.oxml.action.PropertyOXMLAction;
import net.sf.doolin.oxml.action.SequenceOXMLAction;
import net.sf.doolin.util.Utils;

public class OXMLActionFactory {
    private static OXMLActionFactory instance = null;
    private Map<String, Class<? extends OXMLAction>> classes = new HashMap<String, Class<? extends OXMLAction>>();

    private static synchronized OXMLActionFactory createInstance() {
        OXMLActionFactory temp;
        if (instance != null) {
            return instance;
        }
        instance = temp = new OXMLActionFactory();
        return instance;
    }

    public static OXMLActionFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        return OXMLActionFactory.createInstance();
    }

    private OXMLActionFactory() {
        this.classes.put("for", ForOXMLAction.class);
        this.classes.put("create", CreateOXMLAction.class);
        this.classes.put("createDef", CreateDefOXMLAction.class);
        this.classes.put("check", CheckOXMLAction.class);
        this.classes.put("property", PropertyOXMLAction.class);
        this.classes.put("if", IfOXMLAction.class);
        this.classes.put("sequence", SequenceOXMLAction.class);
        this.classes.put("include", IncludeOXMLAction.class);
    }

    public OXMLAction createAction(String name) throws IOException {
        Class<? extends OXMLAction> actionClass = this.classes.get(name);
        if (actionClass != null) {
            OXMLAction action = (OXMLAction)Utils.newInstance(actionClass);
            return action;
        }
        throw new IOException("Cannot find any action for tag " + name);
    }
}

