/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doolin.oxml.action;

import java.io.IOException;
import java.util.ArrayList;
import net.sf.doolin.oxml.OXMLContext;
import net.sf.doolin.oxml.action.AbstractSequenceOXMLAction;
import net.sf.doolin.oxml.adapter.OXMLInstanceFactory;
import net.sf.doolin.oxml.annotation.Collection;
import net.sf.doolin.util.Utils;
import net.sf.doolin.util.xml.DOMUtils;
import net.sf.jstring.LocalizableException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateOXMLAction
extends AbstractSequenceOXMLAction {
    private String node;
    private String className;
    private Class<?> factoryClass;
    private String id;
    private boolean root;
    private String property;
    private String setter;
    private boolean post = false;

    @Override
    public void parse(Element e) throws IOException {
        super.parse(e);
        String defId = DOMUtils.getAttribute((Element)e, (String)"defId", (boolean)false, null);
        if (defId != null) {
            Element eCreateDef = e.getOwnerDocument().getElementById(defId);
            if (eCreateDef == null) {
                throw new LocalizableException("CreateOXMLAction.CreateDefNotFound", new Object[]{defId});
            }
            this.parse(eCreateDef);
        }
        this.node = DOMUtils.getAttribute((Element)e, (String)"node", (boolean)false, null);
        this.className = DOMUtils.getAttribute((Element)e, (String)"class", (boolean)false, (String)this.className);
        this.id = DOMUtils.getAttribute((Element)e, (String)"id", (boolean)false, null);
        this.root = DOMUtils.getBooleanAttribute((Element)e, (String)"root", (boolean)false, (boolean)false);
        this.property = DOMUtils.getAttribute((Element)e, (String)"property", (boolean)false, null);
        this.setter = DOMUtils.getAttribute((Element)e, (String)"setter", (boolean)false, null);
        this.post = DOMUtils.getBooleanAttribute((Element)e, (String)"post", (boolean)false, (boolean)false);
        this.factoryClass = DOMUtils.getClassAttribute((Element)e, (String)"factory", this.factoryClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(OXMLContext context) {
        if (StringUtils.isNotBlank((String)this.node)) {
            NodeList nodes = context.getNodeList(this.node);
            int nodeCount = nodes.getLength();
            for (int i = 0; i < nodeCount; ++i) {
                Node forNode = nodes.item(i);
                context.nodePush(forNode);
                try {
                    this.create(context);
                    continue;
                }
                finally {
                    context.nodePop();
                }
            }
        } else {
            this.create(context);
        }
    }

    protected void collect(Object instance, OXMLContext context) {
        Collection collection = (Collection)Utils.getAnnotation(Collection.class, (Object)instance);
        if (collection != null) {
            String collectionValue;
            String[] collectedProperties;
            String collectionName = collection.name();
            if (StringUtils.isBlank((String)collectionName)) {
                collectionName = StringUtils.substringAfterLast((String)instance.getClass().getName(), (String)".");
            }
            if ((collectedProperties = collection.collectedProperties()) == null || collectedProperties.length == 0) {
                collectionValue = ObjectUtils.toString((Object)instance);
            } else {
                ArrayList<String> values = new ArrayList<String>();
                for (String collectedProperty : collectedProperties) {
                    try {
                        String collectedValue = BeanUtils.getProperty((Object)instance, (String)collectedProperty);
                        values.add(collectedProperty + "=" + collectedValue);
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(String.format("Cannot get %2$s property on the %1$s instance.\n%3$s", instance, collectedProperty, ex), ex);
                    }
                }
                collectionValue = StringUtils.join(values, (String)",");
            }
            context.collect(collectionName, collectionValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(OXMLContext context) {
        Object instance;
        if (this.className != null) {
            instance = context.newInstance(this.className);
        } else {
            OXMLInstanceFactory factory = (OXMLInstanceFactory)Utils.newInstance(this.factoryClass);
            instance = factory.createInstance(context);
        }
        if (StringUtils.isNotBlank((String)this.id)) {
            context.instancePut(this.id, instance);
        }
        if (this.root) {
            context.setRoot(instance);
        }
        if (!this.post) {
            this.setInParent(context, instance);
        }
        context.instancePush(instance);
        try {
            super.process(context);
            this.collect(instance, context);
        }
        finally {
            context.instancePop();
            if (this.post) {
                this.setInParent(context, instance);
            }
        }
    }

    protected void setInParent(OXMLContext context, Object instance) {
        if (StringUtils.isNotBlank((String)this.setter)) {
            Object currentInstance = context.instancePeek();
            if (StringUtils.isNotBlank((String)this.property)) {
                try {
                    Object propertyValue = PropertyUtils.getProperty((Object)currentInstance, (String)this.property);
                    MethodUtils.invokeMethod((Object)propertyValue, (String)this.setter, (Object)instance);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot call method " + this.setter + "on property " + this.property, ex);
                }
            } else {
                try {
                    MethodUtils.invokeMethod((Object)currentInstance, (String)this.setter, (Object)instance);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot call method " + this.setter, ex);
                }
            }
        } else if (StringUtils.isNotBlank((String)this.property)) {
            try {
                BeanUtils.setProperty((Object)context.instancePeek(), (String)this.property, (Object)instance);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot set property " + this.property, ex);
            }
        }
    }
}

