/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doolin.oxml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class OXMLUtils {
    private OXMLUtils() {
    }

    public static void displayCollections(Map<String, Set<Object>> collections) {
        collections = new TreeMap<String, Set<Object>>(collections);
        for (Map.Entry<String, Set<Object>> entry : collections.entrySet()) {
            String name = entry.getKey();
            Set<Object> items = entry.getValue();
            items = new TreeSet<Object>(items);
            System.out.println("[" + name + "]");
            for (Object item : items) {
                System.out.println("\t" + item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCollections(File collectionFile, Map<String, Set<Object>> collections) throws IOException {
        File parent = collectionFile.getParentFile();
        parent.mkdirs();
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(collectionFile)));
        try {
            collections = new TreeMap<String, Set<Object>>(collections);
            for (Map.Entry<String, Set<Object>> entry : collections.entrySet()) {
                String name = entry.getKey();
                Set<Object> items = entry.getValue();
                items = new TreeSet<Object>(items);
                writer.println("[" + name + "]");
                for (Object item : items) {
                    writer.println("\t" + item);
                }
            }
        }
        finally {
            writer.close();
        }
    }
}

