/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doolin.oxml;

import java.io.IOException;
import java.util.Map;
import net.sf.doolin.oxml.OXMLConfig;
import net.sf.doolin.oxml.OXMLContext;
import net.sf.doolin.oxml.OXMLContextConfig;
import net.sf.doolin.oxml.OXMLReaderOutput;
import net.sf.doolin.oxml.OXMLSource;
import net.sf.doolin.oxml.action.OXMLAction;
import org.w3c.dom.Document;

public class OXMLReader<T> {
    private final OXMLConfig config;
    private final Map<String, Object> contextMap;

    public OXMLReader(OXMLConfig cfg) {
        this(cfg, null);
    }

    public OXMLReader(OXMLConfig cfg, Map<String, Object> contextMap) {
        this.config = cfg;
        this.contextMap = contextMap;
    }

    public T read(OXMLSource source) throws IOException {
        return this.read(source, new OXMLReaderOutput(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read(OXMLSource source, OXMLReaderOutput output, OXMLContextConfig contextConfig) throws IOException {
        try {
            Document dom = source.getSource();
            OXMLAction action = this.config.getRootAction();
            OXMLContext context = new OXMLContext(dom);
            if (contextConfig != null) {
                context.setConfig(contextConfig);
            }
            if (this.contextMap != null) {
                context.contextPutAll(this.contextMap);
            }
            action.process(context);
            Object root = context.getTargetRoot();
            context.fill(output);
            Object object = root;
            return (T)object;
        }
        finally {
            source.close();
        }
    }
}

