/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doolin.oxml;

import java.io.IOException;
import java.util.List;
import net.sf.doolin.util.Utils;
import net.sf.doolin.util.xml.DOMUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OXMLFactory {
    private static OXMLFactory instance = null;

    private static synchronized OXMLFactory createInstance() {
        OXMLFactory temp;
        if (instance != null) {
            return instance;
        }
        instance = temp = new OXMLFactory();
        return instance;
    }

    public static OXMLFactory getInstance() {
        if (instance != null) {
            return instance;
        }
        return OXMLFactory.createInstance();
    }

    private OXMLFactory() {
    }

    public <T> T create(Element e) throws IOException {
        Class clazz = DOMUtils.getClassAttribute((Element)e, (String)"class", null);
        if (clazz == null) {
            throw new IOException("Missing 'class' attribute on " + DOMUtils.getXPath((Node)e));
        }
        Object t = Utils.newInstance((Class)clazz);
        List paramList = DOMUtils.getElements((Element)e, (String)"http://www.doolin-guif.net/schema/oxml", (String)"param");
        for (Element eParam : paramList) {
            String name = DOMUtils.getAttribute((Element)eParam, (String)"name", (boolean)true, null);
            String value = DOMUtils.getAttribute((Element)eParam, (String)"value", (boolean)false, null);
            if (!StringUtils.isNotBlank((String)value)) continue;
            try {
                PropertyUtils.setProperty((Object)t, (String)name, (Object)value);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot set property " + name, ex);
            }
        }
        return (T)t;
    }
}

