/*
 * Decompiled with CFR 0.152.
 */
package net.sf.doolin.oxml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sf.doolin.oxml.OXMLContextConfig;
import net.sf.doolin.oxml.OXMLReaderOutput;
import net.sf.doolin.oxml.action.SequenceOXMLAction;
import net.sf.doolin.util.Utils;
import net.sf.doolin.util.xml.DOMUtils;
import net.sf.doolin.util.xml.XPathUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OXMLContext {
    private final Document dom;
    private Object root;
    private final XPathUtils xpath;
    private final Stack<Node> nodeStack;
    private final Map<String, Object> instanceMap;
    private final Stack<Object> instanceStack;
    private OXMLContextConfig config = new OXMLContextConfig();
    private Map<String, Set<Object>> collectionMap;
    private Map<String, SequenceOXMLAction> sequenceMap;
    private String packageName;

    public OXMLContext(Document document) {
        this.dom = document;
        this.xpath = new XPathUtils();
        this.nodeStack = new Stack();
        this.nodeStack.push(this.dom);
        this.instanceMap = new HashMap<String, Object>();
        this.instanceStack = new Stack();
        this.sequenceMap = new HashMap<String, SequenceOXMLAction>(0);
        this.collectionMap = new HashMap<String, Set<Object>>();
    }

    protected void checkUsed(Node node, OXMLReaderOutput output) {
        if (!this.nodeUsed(node)) {
            String x = DOMUtils.getXPath((Node)node);
            String message = x + " has not been used.";
            output.addWarning(message);
        }
        if (node.getNodeType() == 1) {
            Element e = (Element)node;
            NodeList childNodes = e.getChildNodes();
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node childNode = childNodes.item(i);
                switch (childNode.getNodeType()) {
                    case 1: 
                    case 2: {
                        this.checkUsed(childNode, output);
                    }
                }
            }
        }
    }

    public void collect(String collectionName, Object collectionItem) {
        Set<Object> collection = this.collectionMap.get(collectionName);
        if (collection == null) {
            collection = new HashSet<Object>();
            this.collectionMap.put(collectionName, collection);
        }
        collection.add(collectionItem);
    }

    public void contextPutAll(Map<String, Object> context) {
        this.instanceMap.putAll(context);
    }

    public void fill(OXMLReaderOutput output) {
        this.fillCollections(output.getCollections());
        this.fillWarnings(output);
    }

    protected void fillCollections(Map<String, Set<Object>> collections) {
        for (Map.Entry<String, Set<Object>> entry : this.collectionMap.entrySet()) {
            String collectionName = entry.getKey();
            Set<Object> sourceCollection = entry.getValue();
            Set<Object> targetCollection = collections.get(collectionName);
            if (targetCollection == null) {
                targetCollection = new HashSet<Object>(sourceCollection);
                collections.put(collectionName, targetCollection);
                continue;
            }
            targetCollection.addAll(sourceCollection);
        }
    }

    protected void fillWarnings(OXMLReaderOutput output) {
        Element eRoot = this.dom.getDocumentElement();
        this.checkUsed(eRoot, output);
    }

    public OXMLContextConfig getConfig() {
        return this.config;
    }

    public NodeList getNodeList(String path) {
        Node node = this.nodeStack.peek();
        NodeList nodeList = this.xpath.selectNodeList(node, path);
        int nodeCount = nodeList.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            Node forNode = nodeList.item(i);
            this.markUsed(forNode);
        }
        return this.xpath.selectNodeList(node, path);
    }

    public Object getTargetRoot() {
        return this.root;
    }

    public XPathUtils getXpath() {
        return this.xpath;
    }

    public Object instanceGet(String id) {
        return this.instanceMap.get(id);
    }

    public Object instancePeek() {
        return this.instanceStack.peek();
    }

    public Object instancePop() {
        return this.instanceStack.pop();
    }

    public void instancePush(Object instance) {
        this.instanceStack.push(instance);
    }

    public void instancePut(String id, Object instance) {
        this.instanceMap.put(id, instance);
    }

    public void markUsed(Node node) {
        if (node != null) {
            node.setUserData("OXML", true, null);
            Node parentNode = node.getParentNode();
            if (parentNode != null && !this.nodeUsed(parentNode)) {
                this.markUsed(parentNode);
            }
        }
    }

    public Object newInstance(String className) {
        if (!StringUtils.contains((String)className, (char)'.') && StringUtils.isNotBlank((String)this.packageName)) {
            className = this.packageName + "." + className;
        }
        return Utils.newInstance((String)className);
    }

    public Node nodePeek() {
        Node node = this.nodeStack.peek();
        this.markUsed(node);
        return node;
    }

    public Node nodePop() {
        return this.nodeStack.pop();
    }

    public void nodePush(Node node) {
        this.nodeStack.push(node);
    }

    protected boolean nodeUsed(Node node) {
        if (node != null) {
            Boolean used = (Boolean)node.getUserData("OXML");
            return used != null && used != false;
        }
        return true;
    }

    public SequenceOXMLAction sequenceGet(String id) {
        SequenceOXMLAction sequence = this.sequenceMap.get(id);
        if (sequence != null) {
            return sequence;
        }
        throw new IllegalStateException("Cannot find any sequence with ID = " + id);
    }

    public void sequencePut(SequenceOXMLAction sequence) {
        this.sequenceMap.put(sequence.getId(), sequence);
    }

    public void setConfig(OXMLContextConfig config) {
        this.config = config;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setRoot(Object instance) {
        if (this.root != null) {
            throw new IllegalStateException("The root instance has already been set.");
        }
        this.root = instance;
    }
}

