package net.sf.doolin.oxml.adapter;

import java.awt.Dimension;

import net.sf.doolin.oxml.OXMLContext;

import org.apache.commons.lang.StringUtils;

/**
 * {@link OXMLAdapter} for a {@link Dimension} object which has been rendered as
 * "width,height".
 * 
 * @author Damien Coraboeuf
 * 
 */
public class DimensionOXMLAdapter extends AbstractSimpleOXMLAdapter<Dimension> {

	@Override
	protected Dimension adapt(String value, OXMLContext context) {
		if (StringUtils.isNotBlank(value)) {
			String[] tokens = StringUtils.split(value, ",");
			int width = Integer.parseInt(tokens[0], 10);
			int height = Integer.parseInt(tokens[1], 10);
			return new Dimension(width, height);
		} else {
			return null;
		}
	}

}
