package net.sf.doolin.oxml.adapter;

import net.sf.doolin.oxml.OXMLContext;
import net.sf.doolin.util.xml.DOMUtils;

import org.w3c.dom.Node;

/**
 * Adapter that converts the string value to an object.
 * 
 * @param <T>
 *            Expected returned type
 * @author Damien Coraboeuf
 */
public abstract class AbstractSimpleOXMLAdapter<T> implements OXMLAdapter {

	public Object adapt(Node currentNode, String path, OXMLContext context) {
		Node theNode = context.getXpath().selectSingleNode(currentNode, path);
		context.markUsed(theNode);
		String value = DOMUtils.getText(theNode);
		return adapt(value, context);
	}

	/**
	 * Adapts a simple string to an object.
	 * 
	 * @param value
	 *            String to adapt
	 * @param context
	 *            Execution context
	 * @return Created instance
	 */
	protected abstract T adapt(String value, OXMLContext context);

}
