package net.sf.doolin.oxml.adapter;

import net.sf.doolin.oxml.OXMLContext;

import org.w3c.dom.Element;

/**
 * Creates an instance from the current node.
 * 
 * @author Damien Coraboeuf
 * @param <T>
 *            Type of the instance to create
 */
public abstract class AbstractOXMLInstanceFactory<T> implements
		OXMLInstanceFactory<T> {

	/**
	 * Creates the instance from the current element
	 * 
	 * @param element
	 *            Current element
	 * @param context
	 *            Execution context
	 * @return Instance
	 */
	protected abstract T createInstance(Element element, OXMLContext context);

	public T createInstance(OXMLContext context) {
		// Gets the current node as an element
		Element element = (Element) context.nodePeek();
		// Conversion
		return createInstance(element, context);
	}

}
