/*
 * Created on Sep 17, 2007
 */
package net.sf.doolin.oxml.action;

import java.io.IOException;

import net.sf.doolin.oxml.OXMLContext;
import net.sf.doolin.util.xml.DOMUtils;

import org.w3c.dom.Element;

/**
 * <code>sequence</code> action. This action just stores its inner actions and
 * can be executed later by the {@linkplain IncludeOXMLAction include} action.
 * <p>
 * Parameters of this action are:
 * <ul>
 * <li><code>id</code> - (required) ID of the sequence.
 * </ul>
 * 
 * @author Damien Coraboeuf
 */
public class SequenceOXMLAction extends AbstractSequenceOXMLAction {

	private String id;

	/**
	 * Executes the sequence
	 * 
	 * @param context
	 *            Execution context
	 */
	public void execute(OXMLContext context) {
		super.process(context);
	}

	/**
	 * Gets the id.
	 * 
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void parse(Element e) throws IOException {
		// Parses included elements
		super.parse(e);
		// Gets the id
		this.id = DOMUtils.getAttribute(e, "id", true, null);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void process(OXMLContext context) {
		// Just registers this sequence in the context
		context.sequencePut(this);
	}

}
