package net.sf.doolin.oxml.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import net.sf.doolin.util.Utils;

/**
 * Factory for OXML actions.
 * 
 * @author Damien Coraboeuf
 */
public class OXMLActionFactory {

	/**
	 * Unique instance
	 */
	private static OXMLActionFactory instance = null;

	/**
	 * Creates the instance
	 */
	private static synchronized OXMLActionFactory createInstance() {
		if (instance != null) {
			return instance;
		} else {
			OXMLActionFactory temp = new OXMLActionFactory();
			instance = temp;
			return instance;
		}
	}

	/**
	 * Get the instance
	 * 
	 * @return Action factory to be used
	 */
	public static OXMLActionFactory getInstance() {
		if (instance != null) {
			return instance;
		} else {
			return createInstance();
		}
	}

	private Map<String, Class<? extends OXMLAction>> classes = new HashMap<String, Class<? extends OXMLAction>>();

	/**
	 * Initialization
	 */
	private OXMLActionFactory() {
		this.classes.put("for", ForOXMLAction.class);
		this.classes.put("create", CreateOXMLAction.class);
		this.classes.put("createDef", CreateDefOXMLAction.class);
		this.classes.put("check", CheckOXMLAction.class);
		this.classes.put("property", PropertyOXMLAction.class);
		this.classes.put("if", IfOXMLAction.class);
		this.classes.put("sequence", SequenceOXMLAction.class);
		this.classes.put("include", IncludeOXMLAction.class);
	}

	/**
	 * Creates an OXML action from a tag name.
	 * 
	 * @param name
	 *            Tag name
	 * @return Corresponding action
	 * @throws IOException
	 *             If the name cannot be converted to an action
	 */
	public OXMLAction createAction(String name) throws IOException {
		Class<? extends OXMLAction> actionClass = this.classes.get(name);
		if (actionClass != null) {
			OXMLAction action = Utils.newInstance(actionClass);
			return action;
		} else {
			throw new IOException("Cannot find any action for tag " + name);
		}
	}

}
