package net.sf.doolin.oxml.action;

import java.io.IOException;

import net.sf.doolin.oxml.OXMLContext;

import org.w3c.dom.Element;

/**
 * Action to be executed against a context.
 * 
 * @author Damien Coraboeuf
 */
public interface OXMLAction {

	/**
	 * Parses the action from an XML configuration.
	 * 
	 * @param e
	 *            Configuration element for this action.
	 * @throws IOException
	 *             If the element cannot be parsed
	 */
	void parse(Element e) throws IOException;

	/**
	 * Processes the action against a context
	 * 
	 * @param context
	 *            Execution context
	 */
	void process(OXMLContext context);

}
