package net.sf.doolin.oxml.action;

import java.io.IOException;

import net.sf.doolin.oxml.OXMLContext;
import net.sf.doolin.util.xml.DOMUtils;

import org.w3c.dom.Element;

/**
 * <code>include</code> action. This action gets an already defined
 * {@linkplain SequenceOXMLAction sequence} and executes it.
 * <p>
 * Parameters of this action are:
 * <ul>
 * <li><code>id</code> - (required) ID of the sequence to include
 * </ul>
 * 
 * @author Damien Coraboeuf (x74639)
 * 
 */
public class IncludeOXMLAction extends AbstractOXMLAction {

	private String id;

	public void parse(Element e) throws IOException {
		// Gets the id
		this.id = DOMUtils.getAttribute(e, "id", true, null);
	}

	public void process(OXMLContext context) {
		// Gets the sequence
		SequenceOXMLAction sequenceAction = context.sequenceGet(this.id);
		// Executes the sequence
		sequenceAction.execute(context);
	}

}
