/*
 * Created on Sep 17, 2007
 */
package net.sf.doolin.oxml.action;

import java.io.IOException;

import net.sf.doolin.oxml.OXMLContext;
import net.sf.doolin.oxml.adapter.OXMLInstanceFactory;

import org.w3c.dom.Element;

/**
 * <code>createDef</code> action. This action is used by the <code>create</code>
 * action when it has a <code>defId</code> attribute. This action does not do
 * anything by itself.
 * <p>
 * Parameters for this action are:
 * <ul>
 * <li> <code>class</code> - (required if <code>factory</code> is not provided)
 * Name of the instance type to create
 * <li> <code>factory </code> - (required if <code>class</code> is not provided)
 * Class name for an implementation of the
 * <code>{@link OXMLInstanceFactory}</code> interface, responsible for the
 * creation of the instance
 * <li><code>id</code> - (required) Identifier of the create definition.
 * </ul>
 * 
 * @author Damien Coraboeuf
 */
public class CreateDefOXMLAction extends AbstractSequenceOXMLAction {

	/**
	 * Does not do anything.
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void parse(Element e) throws IOException {
	}

	/**
	 * Does not do anything.
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public void process(OXMLContext context) {
	}

}
