package net.sf.doolin.oxml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/**
 * Utilities for OXML.
 * 
 * @author Damien Coraboeuf (x74639)
 * 
 */
public class OXMLUtils {

	private OXMLUtils() {
	}

	/**
	 * Displays the list of collections on the system console.
	 * 
	 * @param collections
	 *            Collections
	 */
	public static void displayCollections(Map<String, Set<Object>> collections) {
		// Sorts the collection names
		collections = new TreeMap<String, Set<Object>>(collections);
		for (Map.Entry<String, Set<Object>> entry : collections.entrySet()) {
			String name = entry.getKey();
			Set<Object> items = entry.getValue();
			items = new TreeSet<Object>(items);
			System.out.println("[" + name + "]");
			for (Object item : items) {
				System.out.println("\t" + item);
			}
		}
	}

	/**
	 * Writes the collections into a file
	 * 
	 * @param collectionFile
	 *            File to write to (its previous content will be overriden)
	 * @param collections
	 *            Collections to write
	 * @throws IOException
	 *             If the content cannot be written
	 */
	public static void writeCollections(File collectionFile,
			Map<String, Set<Object>> collections) throws IOException {
		// Checks the file directories
		File parent = collectionFile.getParentFile();
		parent.mkdirs();
		// Opens the file
		PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(
				collectionFile)));
		try {
			// Sorts the collection names
			collections = new TreeMap<String, Set<Object>>(collections);
			for (Map.Entry<String, Set<Object>> entry : collections.entrySet()) {
				String name = entry.getKey();
				Set<Object> items = entry.getValue();
				items = new TreeSet<Object>(items);
				writer.println("[" + name + "]");
				for (Object item : items) {
					writer.println("\t" + item);
				}
			}
		} finally {
			// Closes the file
			writer.close();
		}
	}
}
