package net.sf.doolin.oxml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Class that collects all different outputs of
 * {@link OXMLReader#read(OXMLSource, OXMLReaderOutput, OXMLContextConfig)}.
 * 
 * @author Damien Coraboeuf
 */
public class OXMLReaderOutput {

	private Map<String, Set<Object>> collections = new HashMap<String, Set<Object>>();
	private List<String> warnings = new ArrayList<String>();

	/**
	 * Adds a warning.
	 * 
	 * @param message
	 *            Warning message
	 */
	public void addWarning(String message) {
		this.warnings.add(message);
	}

	/**
	 * List of collections.
	 * 
	 * @return List of collections
	 */
	public Map<String, Set<Object>> getCollections() {
		return this.collections;
	}

	/**
	 * Gets the warnings.
	 * 
	 * @return the warnings
	 */
	public List<String> getWarnings() {
		return this.warnings;
	}

}
