/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.test;

import java.io.Serializable;
import net.derquinse.common.test.EqualityTests;
import net.derquinse.common.test.UnableToSerializeException;
import org.testng.Assert;

class SerializabilitySupport {
    private SerializabilitySupport() {
        throw new AssertionError();
    }

    static <T extends Serializable> T cast(T obj, Object deserialized, boolean equality) throws UnableToSerializeException {
        Assert.assertNotNull(obj, (String)"The provided object to serialize is null");
        try {
            Serializable d = (Serializable)obj.getClass().cast(deserialized);
            if (equality) {
                EqualityTests.two(obj, deserialized);
            } else {
                Assert.assertNotNull((Object)deserialized, (String)"The deserialized object is null");
            }
            return (T)d;
        }
        catch (ClassCastException e) {
            throw new UnableToSerializeException(e);
        }
    }
}

