/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.derquinse.common.test.SerializabilitySupport;
import net.derquinse.common.test.UnableToSerializeException;
import org.testng.Assert;

public final class SerializabilityTests {
    private SerializabilityTests() {
        throw new AssertionError();
    }

    public static <T extends Serializable> T check(T obj, boolean equality) throws UnableToSerializeException {
        Object deserialized;
        Assert.assertNotNull(obj, (String)"The provided serializable object is null");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            deserialized = ois.readObject();
        }
        catch (Throwable t) {
            throw new UnableToSerializeException(t);
        }
        return SerializabilitySupport.cast(obj, deserialized, equality);
    }

    public static <T extends Serializable> T check(T obj) throws UnableToSerializeException {
        return SerializabilityTests.check(obj, true);
    }
}

