/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.test;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import net.derquinse.common.test.SerializabilitySupport;
import net.derquinse.common.test.UnableToSerializeException;
import org.testng.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HessianSerializabilityTests {
    private HessianSerializabilityTests() {
        throw new AssertionError();
    }

    public static <T extends Serializable> T hessian1(T obj, boolean equality) throws UnableToSerializeException {
        Object deserialized;
        Assert.assertNotNull(obj, (String)"The provided serializable object is null");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            HessianOutput ho = new HessianOutput((OutputStream)bos);
            ho.writeObject(obj);
            ho.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            HessianInput ois = new HessianInput((InputStream)bis);
            deserialized = ois.readObject();
        }
        catch (Throwable t) {
            throw new UnableToSerializeException(t);
        }
        return SerializabilitySupport.cast(obj, deserialized, equality);
    }

    public static <T extends Serializable> T hessian1(T obj) throws UnableToSerializeException {
        return HessianSerializabilityTests.hessian1(obj, true);
    }

    public static <T extends Serializable> T hessian2(T obj, boolean equality) throws UnableToSerializeException {
        Object deserialized;
        Assert.assertNotNull(obj, (String)"The provided serializable object is null");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            Hessian2Output ho = new Hessian2Output((OutputStream)bos);
            ho.writeObject(obj);
            ho.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            Hessian2Input ois = new Hessian2Input((InputStream)bis);
            deserialized = ois.readObject();
        }
        catch (Throwable t) {
            throw new UnableToSerializeException(t);
        }
        return SerializabilitySupport.cast(obj, deserialized, equality);
    }

    public static <T extends Serializable> T hessian2(T obj) throws UnableToSerializeException {
        return HessianSerializabilityTests.hessian2(obj, true);
    }

    public static void both(Serializable obj, boolean equality) throws UnableToSerializeException {
        HessianSerializabilityTests.hessian1(obj, equality);
        HessianSerializabilityTests.hessian2(obj, equality);
    }

    public static void both(Serializable obj) throws UnableToSerializeException {
        HessianSerializabilityTests.hessian1(obj);
        HessianSerializabilityTests.hessian2(obj);
    }
}

