/*
 * Decompiled with CFR 0.152.
 */
package net.derquinse.common.test;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.testng.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EqualityTests {
    private EqualityTests() {
        throw new AssertionError();
    }

    public static void one(Object obj) {
        Assert.assertNotNull((Object)obj, (String)"The provided object is null");
        Assert.assertTrue((boolean)obj.equals(obj), (String)String.format("The object [%s] is not equal to itself", obj));
        Assert.assertFalse((boolean)obj.equals(null), (String)String.format("The object [%s] is equal to null", obj));
    }

    private static void checkTwo(Object obj1, Object obj2) {
        Assert.assertTrue((boolean)obj1.equals(obj2), (String)String.format("The object [%s] is not equal to [%s]", obj1, obj2));
    }

    private static void internalTwo(Object obj1, Object obj2) {
        Assert.assertEquals((int)obj1.hashCode(), (int)obj2.hashCode(), (String)String.format("The object [%s]'s hash code is not equal to [%s]'s", obj1, obj2));
        EqualityTests.checkTwo(obj1, obj2);
        EqualityTests.checkTwo(obj2, obj1);
    }

    public static void two(Object obj1, Object obj2) {
        EqualityTests.one(obj1);
        EqualityTests.one(obj2);
        EqualityTests.internalTwo(obj1, obj2);
    }

    public static void many(@Nullable List<?> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        for (int i = 0; i < objects.size(); ++i) {
            Object obj1 = objects.get(i);
            if (i == 0) {
                EqualityTests.one(obj1);
            }
            for (int j = i + 1; j < objects.size(); ++j) {
                Object obj2 = objects.get(j);
                if (i == 0) {
                    EqualityTests.one(obj2);
                }
                EqualityTests.internalTwo(obj1, obj2);
            }
        }
    }

    public static void many(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return;
        }
        EqualityTests.many(Arrays.asList(objects));
    }
}

