/*
 * Decompiled with CFR 0.152.
 */
package net.sf.derquinsej.hib3.seq;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import net.sf.derquinsej.hib3.seq.Sequence;
import net.sf.derquinsej.hib3.seq.SequenceNotFoundException;
import org.hibernate.LockOptions;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

public class SequenceDAO {
    private final SessionFactory sessionFactory;

    public SequenceDAO(SessionFactory sessionFactory) {
        this.sessionFactory = (SessionFactory)Preconditions.checkNotNull((Object)sessionFactory, (Object)"The session factory is mandatory.");
    }

    private static String nonNull(String id) {
        return (String)Preconditions.checkNotNull((Object)id, (Object)"The sequence name (id) is mandatory.");
    }

    public long getCurrentValue(String id) throws SequenceNotFoundException {
        SequenceDAO.nonNull(id);
        Session session = this.sessionFactory.getCurrentSession();
        Sequence sequence = (Sequence)session.get(Sequence.class, (Serializable)((Object)id), LockOptions.READ);
        if (sequence == null) {
            throw new SequenceNotFoundException(id);
        }
        return sequence.getCurrent();
    }

    public long getNextValue(String id) throws SequenceNotFoundException {
        SequenceDAO.nonNull(id);
        Session session = this.sessionFactory.getCurrentSession();
        Sequence sequence = (Sequence)session.get(Sequence.class, (Serializable)((Object)id), LockOptions.UPGRADE);
        if (sequence == null) {
            throw new SequenceNotFoundException(id);
        }
        long next = sequence.getNext();
        session.update((Object)sequence);
        return next;
    }

    public long getNextValue(String id, long initial, long increment) {
        SequenceDAO.nonNull(id);
        Session session = this.sessionFactory.getCurrentSession();
        Sequence sequence = (Sequence)session.get(Sequence.class, (Serializable)((Object)id), LockOptions.UPGRADE);
        if (sequence != null) {
            return sequence.getNext();
        }
        sequence = new Sequence(id, initial, increment);
        session.save((Object)sequence);
        return initial;
    }
}

