/*
 * Decompiled with CFR 0.152.
 */
package net.sf.derquinsej.hib3;

import com.google.common.base.Preconditions;
import java.util.List;
import net.sf.derquinsej.hib3.DAO;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDAOImpl
implements DAO {
    private SessionFactory sessionFactory;

    private static SessionFactory check(SessionFactory sessionFactory) {
        return (SessionFactory)Preconditions.checkNotNull((Object)sessionFactory, (Object)"A session factory must be provided.");
    }

    public AbstractDAOImpl(SessionFactory sessionFactory) {
        this.sessionFactory = AbstractDAOImpl.check(sessionFactory);
    }

    public AbstractDAOImpl() {
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected final Session getSession() {
        Preconditions.checkState((this.sessionFactory != null ? 1 : 0) != 0, (Object)"A session factory must have been provided");
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public void clear() {
        this.getSession().clear();
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public void sync() {
        Session s = this.getSession();
        s.flush();
        s.clear();
    }

    protected void evict(Object object) {
        this.getSession().evict(object);
    }

    protected Query getNamedQuery(String queryName) {
        Preconditions.checkNotNull((Object)queryName);
        return this.getSession().getNamedQuery(queryName);
    }

    protected <T> List<T> list(Class<T> type, Query query) {
        Preconditions.checkNotNull((Object)query);
        List list = query.list();
        return list;
    }

    protected <T> T first(Class<T> type, Query query) {
        List<T> list = this.list(type, query);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    protected <T> T unique(Class<T> type, Query query) {
        Preconditions.checkNotNull((Object)query);
        Object result = query.uniqueResult();
        return (T)result;
    }

    protected <T> List<T> list(Class<T> type, String queryName, Object value) {
        Preconditions.checkNotNull((Object)queryName);
        Preconditions.checkNotNull((Object)value);
        return this.list(type, this.getNamedQuery(queryName).setParameter(0, value));
    }

    protected <T> T unique(Class<T> type, String queryName, Object value) {
        Preconditions.checkNotNull((Object)queryName);
        Preconditions.checkNotNull((Object)value);
        return this.unique(type, this.getNamedQuery(queryName).setParameter(0, value));
    }
}

