/*
 * Decompiled with CFR 0.152.
 */
package net.sf.derquinsej.hib3.seq;

import com.google.common.base.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="DRQJ_SEQUENCE")
public class Sequence {
    @Id
    @Column(name="TXSQ_NAME", nullable=false, unique=true, updatable=false)
    private String id;
    @Column(name="TXSQ_CURRENT", nullable=false)
    private long current;
    @Column(name="TXSQ_INCREMENT", nullable=false)
    private long increment = 1L;

    public Sequence() {
    }

    Sequence(String id, long initial, long increment) {
        if (increment == 0L) {
            throw new IllegalArgumentException("Increment cannot be zero");
        }
        this.id = (String)Objects.nonNull((Object)id, (String)"Sequence name is mandatory.");
        this.current = initial;
        this.increment = increment;
    }

    public String getId() {
        return this.id;
    }

    public long getCurrent() {
        return this.current;
    }

    long getNext() {
        this.current += this.increment;
        return this.current;
    }

    public long getIncrement() {
        return this.increment;
    }

    public void setIncrement(long increment) {
        if (increment == 0L) {
            throw new IllegalArgumentException("Increment cannot be zero");
        }
        if (this.increment == increment) {
            return;
        }
        if (this.increment > 0L && this.increment > increment || this.increment < 0L && this.increment < increment) {
            throw new IllegalArgumentException("New increment must be same sign and greater absolute value then the old one");
        }
        this.increment = increment;
    }
}

