/*
 * Decompiled with CFR 0.152.
 */
package net.sf.derquinsej.hib3;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import net.sf.derquinsej.hib3.AbstractDAOImpl;
import net.sf.derquinsej.hib3.GenericDAO;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericDAOImpl<T, ID extends Serializable>
extends AbstractDAOImpl
implements GenericDAO<T, ID> {
    private Class<T> persistentClass;

    public GenericDAOImpl(SessionFactory sessionFactory) {
        super(sessionFactory);
        Class type;
        this.persistentClass = type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public GenericDAOImpl(Class<T> persistentClass, SessionFactory sessionFactory) {
        super(sessionFactory);
        this.persistentClass = (Class)Preconditions.checkNotNull(persistentClass);
    }

    public GenericDAOImpl() {
        Class type;
        this.persistentClass = type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public GenericDAOImpl(Class<T> persistentClass) {
        this.persistentClass = (Class)Preconditions.checkNotNull(persistentClass);
    }

    protected final Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public void delete(T entity) {
        Preconditions.checkNotNull(entity);
        this.getSession().delete(entity);
    }

    @Override
    public void deleteById(ID id) {
        Preconditions.checkNotNull(id);
        T entity = this.findById(id, true);
        if (entity != null) {
            this.delete(entity);
        }
    }

    @Override
    public List<T> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    @Override
    public T findById(ID id, boolean lock) {
        if (lock) {
            return (T)this.getSession().get(this.persistentClass, id, LockMode.UPGRADE);
        }
        return (T)this.getSession().get(this.persistentClass, id);
    }

    @Override
    public T save(T entity) {
        Preconditions.checkNotNull(entity);
        this.getSession().save(entity);
        return entity;
    }

    @Override
    public T saveOrUpdate(T entity) {
        Preconditions.checkNotNull(entity);
        this.getSession().saveOrUpdate(entity);
        return entity;
    }

    @Override
    public T update(T entity) {
        Preconditions.checkNotNull(entity);
        this.getSession().update(entity);
        return entity;
    }

    protected final Criteria newCriteria() {
        return this.getSession().createCriteria(this.persistentClass);
    }

    protected final List<T> findByCriteria(Criterion ... criterion) {
        Criteria criteria = this.newCriteria();
        Criterion[] criterionArray = criterion;
        int n = criterion.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            criteria.add(c);
            ++n2;
        }
        List list = criteria.list();
        return list;
    }

    protected final List<T> list(Query query) {
        return this.list(this.persistentClass, query);
    }

    protected final T first(Query query) {
        return this.first(this.persistentClass, query);
    }

    protected final T unique(Query query) {
        return this.unique(this.persistentClass, query);
    }
}

