/*
 * Decompiled with CFR 0.152.
 */
package net.sf.derquinsej.hib3;

import com.google.common.base.Preconditions;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDAOImpl {
    private SessionFactory sessionFactory;

    private static SessionFactory check(SessionFactory sessionFactory) {
        return (SessionFactory)Preconditions.checkNotNull((Object)sessionFactory, (Object)"A session factory must be provided.");
    }

    public AbstractDAOImpl(SessionFactory sessionFactory) {
        this.sessionFactory = AbstractDAOImpl.check(sessionFactory);
    }

    public AbstractDAOImpl() {
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected final Session getSession() {
        Preconditions.checkState((this.sessionFactory != null ? 1 : 0) != 0, (Object)"A session factory must have been provided");
        return this.sessionFactory.getCurrentSession();
    }

    public void clear() {
        this.getSession().clear();
    }

    public void flush() {
        this.getSession().flush();
    }

    protected final Query getNamedQuery(String queryName) {
        Preconditions.checkNotNull((Object)queryName);
        return this.getSession().getNamedQuery(queryName);
    }

    protected final <T> List<T> list(Class<T> type, Query query) {
        Preconditions.checkNotNull((Object)query);
        List list = query.list();
        return list;
    }

    protected final <T> T first(Class<T> type, Query query) {
        List<T> list = this.list(type, query);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    protected final <T> T unique(Class<T> type, Query query) {
        Preconditions.checkNotNull((Object)query);
        Object result = query.uniqueResult();
        return (T)result;
    }
}

