/*
 * Decompiled with CFR 0.152.
 */
package net.sf.derquinsej.hib3;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import net.sf.derquinsej.hib3.GenericDAO;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericDAOImpl<T, ID extends Serializable>
implements GenericDAO<T, ID> {
    private Class<T> persistentClass;
    private final SessionFactory sessionFactory;

    private static SessionFactory check(SessionFactory sessionFactory) {
        return (SessionFactory)Preconditions.checkNotNull((Object)sessionFactory, (Object)"A session factory must be provided.");
    }

    public GenericDAOImpl(SessionFactory sessionFactory) {
        Class type;
        this.persistentClass = type = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.sessionFactory = GenericDAOImpl.check(sessionFactory);
    }

    public GenericDAOImpl(Class<T> persistentClass, SessionFactory sessionFactory) {
        this.persistentClass = (Class)Preconditions.checkNotNull(persistentClass);
        this.sessionFactory = GenericDAOImpl.check(sessionFactory);
    }

    protected final Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    protected final Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public void clear() {
        this.getSession().clear();
    }

    @Override
    public void delete(T entity) {
        Preconditions.checkNotNull(entity);
        this.getSession().delete(entity);
    }

    @Override
    public void deleteById(ID id) {
        Preconditions.checkNotNull(id);
        T entity = this.findById(id, true);
        if (entity != null) {
            this.delete(entity);
        }
    }

    @Override
    public List<T> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    @Override
    public T findById(ID id, boolean lock) {
        if (lock) {
            return (T)this.getSession().get(this.persistentClass, id, LockMode.UPGRADE);
        }
        return (T)this.getSession().get(this.persistentClass, id);
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public T save(T entity) {
        Preconditions.checkNotNull(entity);
        this.getSession().save(entity);
        return entity;
    }

    @Override
    public T saveOrUpdate(T entity) {
        Preconditions.checkNotNull(entity);
        this.getSession().saveOrUpdate(entity);
        return entity;
    }

    @Override
    public T update(T entity) {
        Preconditions.checkNotNull(entity);
        this.getSession().update(entity);
        return entity;
    }

    protected final Criteria newCriteria() {
        return this.getSession().createCriteria(this.persistentClass);
    }

    protected final List<T> findByCriteria(Criterion ... criterion) {
        Criteria criteria = this.newCriteria();
        Criterion[] criterionArray = criterion;
        int n = criterion.length;
        int n2 = 0;
        while (n2 < n) {
            Criterion c = criterionArray[n2];
            criteria.add(c);
            ++n2;
        }
        List list = criteria.list();
        return list;
    }

    protected final Query getNamedQuery(String queryName) {
        Preconditions.checkNotNull((Object)queryName);
        return this.getSession().getNamedQuery(queryName);
    }

    protected final List<T> list(Query query) {
        Preconditions.checkNotNull((Object)query);
        List list = query.list();
        return list;
    }

    protected final T first(Query query) {
        List<T> list = this.list(query);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    protected final T unique(Query query) {
        Preconditions.checkNotNull((Object)query);
        Object result = query.uniqueResult();
        return (T)result;
    }
}

