package net.sf.cuf.examples.model.uc4;

import net.sf.cuf.fw2.DialogPc;
import net.sf.cuf.fw2.AbstractDialogPc;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.model.SelectionInList;

import java.util.Map;
import java.util.Date;

/**
 * UseCase4Pc is the presentation component of a very simple dialog.
 * It is used as the base for a "fill in" exercise.
 */
public class UseCase4Pc extends AbstractDialogPc implements DialogPc, SwingXMLBuilder.Backlink
{
    /** the builder that created us */
    private SwingXMLBuilder mBuilder;

    /**
     * Callback method for the Builder.
     * @param pBuilder the builder that created that object
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method is called by the dialog controller peer during
     * the initialisation phase of an application.
     * @param pDc our peer dialog controller
     * @param pArgs variable argument list modeled as a key/value map,
     *              never null.
     */
    @Override
    public void init(final Dc pDc, final Map<String, ? super Object> pArgs)
    {
        super.init(pDc, pArgs);
    }

    /**
     * Callback when a date should be added.
     */
    public void addDate()
    {
        System.out.println("UseCase4Pc.addDate()");
        // we add a new Date to our List at the right position (end of list
        // if there is no selection or at the current index position)
        Date            now  = new Date();
        SelectionInList sil  = (SelectionInList)mBuilder.getNonVisualObject("DatesSILVM");
        int             index= sil.getIndex();
        if (index>=0)
        {
            sil.addItem(index, now);
        }
        else
        {
            sil.addItem(now);
        }
    }

    /**
     * Callback when a date should be removed.
     */
    public void removeDate()
    {
        System.out.println("UseCase4Pc.removeDate()");
        // TODO: remove the date of the current item
    }

    /**
     * Called from the DialogDc peer in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    public Object getVisualPresentation()
    {
        return mBuilder.getComponentByName("UC4");
    }
}
