package net.sf.cuf.examples;

import net.sf.cuf.ui.SwingDecorator;

import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JLabel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.Insets;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

/**
 * Example for the SwingDecorator/SwingMapping/SwingConnectionManager classes.
 */
public class TestPanel extends JPanel
{
    public TestPanel()
    {
        setName("TestPanel");
        GridBagLayout layout= new GridBagLayout();
        setLayout(layout);

        GridBagConstraints constraints= new GridBagConstraints();
        constraints.fill   = GridBagConstraints.NONE;
        constraints.insets = new Insets(4, 4, 4, 4);

        JLabel textLabel= new JLabel();
        textLabel.setName("textLabel");
        SwingDecorator.initialize(textLabel, "myLabel");
        constraints.gridx = 0;
        constraints.gridy = 0;
        layout.setConstraints(textLabel, constraints);
        add(textLabel);

        JLabel usageCounter= new JLabel();
        usageCounter.setName("usageCounter");
        SwingDecorator.initialize(usageCounter, "myCounter");
        constraints.gridx = 0;
        constraints.gridy = 1;
        layout.setConstraints(usageCounter, constraints);
        add(usageCounter);

        JTextField textField= new JTextField();
        textField.setName("textField");
        SwingDecorator.initialize(textField, "myTextField");
        constraints.gridx    = 1;
        constraints.gridy    = 0;
        constraints.fill     = GridBagConstraints.HORIZONTAL;
        constraints.gridwidth= 2;
        constraints.weightx  = 1.0;
        layout.setConstraints(textField, constraints);
        constraints.gridwidth= 1;
        constraints.fill     = GridBagConstraints.NONE;
        constraints.weightx  = 0.0;
        add(textField);

        JPanel filler= new JPanel(null, false);
        constraints.gridx    = 2;
        constraints.gridy    = 2;
        constraints.fill     = GridBagConstraints.BOTH;
        Insets oldInsets     = constraints.insets;
        constraints.insets   = new Insets(0, 0, 0, 0);
        constraints.weighty  = 1.0;
        layout.setConstraints(filler, constraints);
        constraints.fill     = GridBagConstraints.NONE;
        constraints.weighty  = 0.0;
        constraints.insets   = oldInsets;
        add(filler);

        JButton button= new JButton();
        button.setName("button");
        SwingDecorator.initialize(button, "myButton");
        constraints.gridx = 1;
        constraints.gridy = 1;
        layout.setConstraints(button, constraints);
        add(button);
    }

    /**
     * Starts the panel standalone to quickly test layout issues.
     *
     * @param args not used
     */
    public static void main(final String[] args)
    {
        SwingDecorator.addBundle("i18n/test");

        JFrame frame= new JFrame();
        SwingDecorator.initialize(frame, "myFrame");
        frame.getContentPane().add(new TestPanel());
        frame.addWindowListener(new WindowAdapter()
        {
            public void windowClosing(final WindowEvent e)
            {
                System.exit(0);
            }
        });
        frame.setSize(600, 600);
        frame.show();
    }
}
