/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples.model.uc1;

import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import net.sf.cuf.examples.model.uc1.UserData;
import net.sf.cuf.xfer.AbstractRequest;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.Request;
import net.sf.cuf.xfer.RequestDelegate;
import net.sf.cuf.xfer.Response;

public class LoadDataRequest
extends AbstractRequest<List<UserData>>
implements RequestDelegate<List<UserData>> {
    private int mDummyDataCounter;

    public LoadDataRequest(int pDummyDataCounter) {
        this.mDummyDataCounter = pDummyDataCounter;
    }

    public Response<List<UserData>> execute() {
        DefaultResponse back = new DefaultResponse();
        try {
            Properties p = new Properties();
            p.load(new FileInputStream("modeltest.data"));
            int n = Integer.parseInt(p.getProperty("list.length"));
            ArrayList<UserData> dummyData = new ArrayList<UserData>();
            for (int i = 0; i < n; ++i) {
                UserData userData = new UserData();
                userData.setFirstName(p.getProperty("FirstName." + i));
                userData.setLastName(p.getProperty("LastName." + i));
                userData.setMiddleName(p.getProperty("MiddleName." + i));
                String born = p.getProperty("Born." + i);
                SimpleDateFormat dateParser = new SimpleDateFormat();
                userData.setBorn(born == null ? new Date() : dateParser.parse(born));
                dummyData.add(userData);
            }
            back.setResult(dummyData);
        }
        catch (Exception e) {
            System.out.println("Warning: could not load real data, using dummy data");
            System.out.println("    " + e);
            return this.execute((Request<List<UserData>>)this);
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return back;
    }

    public Response<List<UserData>> execute(Request<List<UserData>> pRequest) {
        DefaultResponse back = new DefaultResponse();
        ArrayList<UserData> dummyData = new ArrayList<UserData>();
        for (int i = 0; i < 10; ++i) {
            UserData userData = new UserData();
            userData.setFirstName("Vorname" + (i + this.mDummyDataCounter));
            userData.setLastName("Nachname" + (i + this.mDummyDataCounter));
            userData.setMiddleName("Mittel" + (i + this.mDummyDataCounter));
            userData.setBorn(new Date());
            dummyData.add(userData);
        }
        back.setResult(dummyData);
        return back;
    }
}

