package net.sf.cuf.examples.model.uc1;

import net.sf.cuf.xfer.AbstractRequest;
import net.sf.cuf.xfer.Response;
import net.sf.cuf.xfer.DefaultResponse;

import java.util.List;
import java.util.Properties;
import java.util.Date;
import java.io.FileOutputStream;

/**
 * This class simulates a server access by saving a List of data objects
 * to a properties file.
 */
public class SaveDataRequest<T> extends AbstractRequest<T>
{
    // our list, never null
    private List mData;

    public SaveDataRequest(final List pData)
    {
        super();
        if (pData==null)
        {
            throw new IllegalArgumentException("list must not be null");
        }
        mData= pData;
    }

    /**
     * Generate a response for the current request state.
     * @return the response (must not be null)
     */
    public Response<T> execute()
    {
        DefaultResponse<T> back= new DefaultResponse<>();
        try
        {
            Properties p= new Properties();
            p.setProperty("list.length", Integer.toString(mData.size()));

            for (int i= 0, n= mData.size(); i< n; i++)
            {
                UserData userData= (UserData)mData.get(i);
                p.setProperty("FirstName."+i,   userData.getFirstName());
                p.setProperty("LastName."+i,    userData.getLastName());
                p.setProperty("MiddleName."+i,  userData.getMiddleName());
                Date born= userData.getBorn();
                if (born!=null)
                    p.setProperty("Born."+i, born.toString());
            }
            p.store(new FileOutputStream("modeltest.data"), "modeltest data");

            back.setResult("");
        }
        catch (Exception e)
        {
            back.setError(e);
        }

        // simulate a long running server access
        try
        {
            Thread.sleep(2000);
        }
        catch (InterruptedException ignored) { }

        return back;
    }
}
