package net.sf.cuf.examples;

import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.ui.DispatcherAction;

import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JDialog;
import javax.swing.JButton;
import java.awt.event.ActionEvent;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Dimension;
import java.awt.Point;
import java.io.InputStream;
import java.util.Map;
import java.util.HashMap;

/**
 * small sample presentation component to demonstate the use
 * of SwingXMLBuilder
 */
public class TestPk2
{
    // our mapping helper
    private SwingXMLBuilder mBuilder;

    // number of calls of our business method
    private int             mCounter;

    /**
     * The constructor does nothing.
     */
    public TestPk2()
    {
    }

    /**
     * This method initializes everything.
     * @param pBuilder the builder that build us
     */
    public void init(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;

        // set counter
        mCounter= 0;
        setCounter();

        // make our frame visible
        JFrame frame= (JFrame)mBuilder.getContainerByName("myFrame");
        frame.pack();
        frame.show();
    }

    /**
     * Our "business" method that is called from both the button and the
     * textfield. It takes any non-empty text from the text field, reverses
     * it an stores it back in the text field
     *
     * @param e not used
     */
    public void reverse(final ActionEvent e)
    {
        JTextField textField= (JTextField) mBuilder.getComponentByName("myFrame/TestPanel/textField");
        String     oldText  = textField.getText();
        if (!"".equals(oldText))
        {
            StringBuilder sb = new StringBuilder(oldText);
            textField.setText(sb.reverse().toString());

            mCounter++;
            setCounter();
        }
    }

    /**
     * Exit program
     * @param e event of the action
     */
    public void quit(final ActionEvent e)
    {
        System.out.println("quit");
        System.out.println("real source: "+((DispatcherAction)e.getSource()).getRealSource());
        System.exit(0);
    }

    /**
     * Print something on stdout.
     * @param e not used
     */
    public void help(final ActionEvent e)
    {
        System.out.println("help");
    }

    /**
     * Show an about dialog.
     * @param e not used
     */
    public void about(final ActionEvent e)
    {
        // we want a modal dialog
        JDialog aboutDialog= (JDialog) mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.setModal(true);

        // set a default button
        JButton okButton= (JButton) mBuilder.getComponentByName("myFrame/aboutDialog/Panel/OK");
        aboutDialog.getRootPane().setDefaultButton(okButton);

        // calculate size
        aboutDialog.pack();

        // center dialog with respect to its parent
        Rectangle parentBounds= aboutDialog.getParent().getBounds();
        if (false)
        {
            // alternative centering with respect to the screen
            Dimension screenSize= Toolkit.getDefaultToolkit().getScreenSize();
            parentBounds= new Rectangle(new Point(0,0), screenSize);
        }
        System.out.println("parent bounds:"+parentBounds);
        int deltaX = (parentBounds.width  - aboutDialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - aboutDialog.getBounds().height) / 2;
        aboutDialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);

        // make dialog visible
        aboutDialog.show();
        System.out.println("after aboutDialog.show()");
    }

    /**
     * Act on "OK" in the about dialog.
     * @param e not used
     */
    public void aboutOk(final ActionEvent e)
    {
        JDialog aboutDialog= (JDialog) mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.hide();
        System.out.println("about was OK!");
    }

    /**
     * Act on "ESCAPE" or "CANCEL" in the about dialog.
     * @param e not used
     */
    public void aboutCancel(final ActionEvent e)
    {
        JDialog aboutDialog= (JDialog) mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.hide();
        System.out.println("about was CANCELED!");
    }

    /**
     * Small helper method to update the counter in the UI.
     */
    private void setCounter()
    {
        JLabel usageCounter= (JLabel) mBuilder.getComponentByName("myFrame/TestPanel/usageCounter");
        usageCounter.setText(Integer.toString(mCounter));
    }

    /**
     * Starts the app.
     * Try -Dswing.defaultlaf=com.sun.java.swing.plaf.windows.WindowsLookAndFeel on the command line.
     *
     * @param args not used
     */
    public static void main(final String[] args)
    {
        InputStream input= Thread.currentThread().getContextClassLoader().getResourceAsStream("TestPk2.xml");

        // show both ways how an non-visual object can be integrated with SwingXMLBuilder
        boolean createWithExternalNonVisual= true;
        if (createWithExternalNonVisual)
        {
            // create pk first, push it to builder
            TestPk2         pk       = new TestPk2();
            Map             nonvisual= new HashMap();
            nonvisual.put("Pk", pk);
            SwingXMLBuilder builder= SwingXMLBuilder.create(input, nonvisual);
            pk.init(builder);

        }
        else
        {
            // pk is generated automatically through builder, pull it out from builder
            SwingXMLBuilder builder= SwingXMLBuilder.create(input);
            TestPk2         pk     = (TestPk2)builder.getNonVisualObject("Pk");
            pk.init(builder);
        }
        // a third way to get the XML Builder object and the PK together
        // is to implement the setSwingXMLBuidler() method in the non-visual class
    }
}
