/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples.model.uc3;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JTextField;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.examples.model.uc3.ModalDc;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AbstractDialogPc;
import net.sf.cuf.fw2.CloseDialogEvent;
import net.sf.cuf.fw2.DialogDc;
import net.sf.cuf.fw2.DialogPc;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class ModalPc
extends AbstractDialogPc
implements DialogPc,
SwingXMLBuilder.Backlink {
    private SwingXMLBuilder mBuilder;
    private ModalDc mDc;
    private DialogDc mParentDc;

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        super.init(pDc, pArgs);
        this.mDc = (ModalDc)pDc;
        if (pArgs.get("parent") instanceof DialogDc) {
            this.mParentDc = (DialogDc)pArgs.get("parent");
        }
    }

    public Object getVisualPresentation() {
        return this.mBuilder.getComponentByName("Dialog");
    }

    public void dispose(Map<String, ? super Object> pArgs) {
        super.dispose(pArgs);
        JDialog dialog = (JDialog)this.mBuilder.getContainerByName("Dialog");
        dialog.dispose();
    }

    void show() {
        Rectangle parentBounds;
        Object visual;
        JDialog dialog = (JDialog)this.mBuilder.getContainerByName("Dialog");
        JTextField inputTF = (JTextField)this.mBuilder.get("Dialog/Panel/Text");
        inputTF.setText("");
        dialog.pack();
        Component parent = null;
        if (this.mParentDc != null && (visual = this.mParentDc.getVisualPresentation()) instanceof Container) {
            parent = (Container)visual;
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
        }
        if (parent == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            parentBounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        } else {
            parentBounds = parent.getBounds();
        }
        int deltaX = (parentBounds.width - dialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - dialog.getBounds().height) / 2;
        dialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);
        dialog.show();
    }

    void hide() {
        JDialog dialog = (JDialog)this.mBuilder.getContainerByName("Dialog");
        dialog.hide();
    }

    public void ok() {
        JTextField inputTF = (JTextField)this.mBuilder.get("Dialog/Panel/Text");
        String input = inputTF.getText();
        this.mDc.setResult(input);
        this.close();
    }

    public void cancel() {
        this.mDc.setResult(null);
        this.close();
    }

    private void close() {
        CloseDialogEvent close = new CloseDialogEvent((Object)this, (Dc)this.mDc);
        this.postAppEvent((AppEvent)close);
    }
}

