package net.sf.cuf.examples;

import net.sf.cuf.ui.builder.PopupManager;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

import javax.swing.JFrame;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.Map;
import java.util.HashMap;

/**
 * small "hello world" example to demonstate the use of SwingXMLBuilder
 */
public class Popup
{
    // our mapping helper
    private SwingXMLBuilder mBuilder;

    /**
     * This method initializes everything.
     * @param pBuilder the builder that build us
     */
    public void init(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * Quits the application
     * @param e not used
     */
    public void quit(final ActionEvent e)
    {
        System.out.println("quit");
        System.exit(0);
    }

    /**
     * report information about the popup.
     * @param e trigger action
     */
    public void doHallo(final ActionEvent e)
    {
        System.out.println("popup event:"+e);
        Object source= e.getSource();
        if (source instanceof JComponent)
        {
            System.out.println("event came from widget "+mBuilder.getNameByComponent((JComponent)source));
            JPopupMenu popup= PopupManager.getRootPopup(e);
            System.out.println("contained in popup: "+mBuilder.getNameByComponent(popup));
            JComponent trigger= PopupManager.getPopupTrigger(e);
            System.out.println("trigger: "+mBuilder.getNameByComponent(trigger));
        }
        else
        {
            System.out.println("event came from object "+source);
        }
    }

    /**
     * Starts the app.
     *
     * @param args not used
     */
    public static void main(final String[] args)
    {
        // create pk first, push it to builder
        Popup pk       = new Popup();
        Map    nonvisual= new HashMap();
        nonvisual.put("Pk", pk);
        String          fileName= "Popup.xml";
        InputStream     input   = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        SwingXMLBuilder builder = SwingXMLBuilder.create(input, nonvisual);
        pk.init(builder);

        // make the frames visible
        JFrame tableFrame= (JFrame)builder.getContainerByName("TableFrame");
        tableFrame.pack();
        tableFrame.show();
    }
}
