/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples.model.portal;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cuf.appevent.AppEvent;
import net.sf.cuf.examples.model.portal.AboutDc;
import net.sf.cuf.examples.model.portal.PortalPc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AbstractAppDc;
import net.sf.cuf.fw2.CloseDialogEvent;
import net.sf.cuf.fw2.DialogApplication;
import net.sf.cuf.fw2.DialogDc;
import net.sf.cuf.fw2.DialogDescription;
import net.sf.cuf.fw2.DialogManager;
import net.sf.cuf.fw2.OpenDialogEvent;
import net.sf.cuf.fw2.ShowStatusEvent;
import net.sf.cuf.ui.SwingConnectionManager;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class PortalDc
extends AbstractAppDc
implements DialogManager.DialogCallback {
    private PortalPc mPc;
    private SwingXMLBuilder mBuilder;
    private DialogApplication mApp;
    static final String KNOWN_DIALOGS = "knownDialogs";

    public void init(Dc pParent, Map<String, ? super Object> pArgs) {
        super.init(pParent, pArgs);
        this.mApp = (DialogApplication)pArgs.get("Application");
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("modeltest/modeltest.xml");
        HashMap<String, PortalDc> nonVisual = new HashMap<String, PortalDc>();
        nonVisual.put("PortalDc", this);
        this.mBuilder = SwingXMLBuilder.create((InputStream)in, nonVisual);
        this.mDialogManager.setCallback((DialogManager.DialogCallback)this);
        Map knownDialogs = DialogDescription.loadKnownDialogs((String)"modeltest/ucdialogs.properties");
        DialogDescription.initDialogs((Map)knownDialogs, (Application)this.mApp, (Dc)this, pArgs);
        DialogDescription description = new DialogDescription();
        AboutDc aboutDc = (AboutDc)((Object)this.mBuilder.getNonVisualObject("AboutDc"));
        aboutDc.init((Dc)this, pArgs);
        description.setDc((Dc)aboutDc);
        description.setDialogId("About");
        knownDialogs.put(description.getDialogId(), description);
        this.mDialogManager.setKnownDialogs(knownDialogs);
        knownDialogs.remove("About");
        this.mPc = (PortalPc)((Object)this.mBuilder.getNonVisualObject("PortalPc"));
        HashMap<String, ? super Object> args = new HashMap<String, Object>(pArgs);
        args.put(KNOWN_DIALOGS, knownDialogs);
        this.mPc.init((Dc)this, args);
    }

    public void dialogOpened(Dc pDc, Map<String, Object> pArgs) {
        if (pDc instanceof DialogDc && !(pDc instanceof AboutDc)) {
            this.mPc.showSubDialog(((DialogDc)pDc).getVisualPresentation());
        }
    }

    public void dialogClosed(Dc pDc, boolean pWasClosed, Map<String, Object> pArgs) {
        if (pWasClosed && pDc instanceof DialogDc && !(pDc instanceof AboutDc)) {
            ShowStatusEvent e = new ShowStatusEvent((Object)this);
            this.postAppEvent((AppEvent)e);
            this.mPc.hideSubDialog();
        }
    }

    public boolean canPassivate() {
        return this.mDialogManager.canPassivate();
    }

    public void doActivate(Map<String, ? super Object> pArgs) {
        this.mPc.show();
    }

    public void doPassivate(Map<String, ? super Object> pArgs) {
        this.mPc.hide();
    }

    public void dispose(Map<String, ? super Object> pArgs) {
        this.mDialogManager.dispose(pArgs);
        SwingConnectionManager.removeConnection((Object)((Object)this));
        this.mBuilder.dispose();
        this.mPc.dispose(pArgs);
        super.dispose(pArgs);
    }

    public void quit() {
        CloseDialogEvent close = new CloseDialogEvent((Object)this, (Dc)this);
        this.postAppEvent((AppEvent)close);
    }

    public void newWindow() {
        OpenDialogEvent open = new OpenDialogEvent((Object)this, "AppDc");
        this.postAppEvent((AppEvent)open);
    }

    public void about() {
        OpenDialogEvent open = new OpenDialogEvent((Object)this, "About");
        this.postAppEvent((AppEvent)open);
    }

    boolean activateDialog(String pNewDialogId) {
        boolean canPassivate = true;
        List activeDialogs = this.mDialogManager.getActiveDialogs();
        for (Dc activeDialog : activeDialogs) {
            DialogDc dialogDc = (DialogDc)activeDialog;
            CloseDialogEvent close = new CloseDialogEvent((Object)this, (Dc)dialogDc);
            this.postAppEvent((AppEvent)close);
            canPassivate = canPassivate && close.getWasClosed();
        }
        if (canPassivate) {
            OpenDialogEvent open = new OpenDialogEvent((Object)this, pNewDialogId);
            this.postAppEvent((AppEvent)open);
            return true;
        }
        return false;
    }
}

