package net.sf.cuf.examples.model.multi;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import net.sf.cuf.examples.model.AppData;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AbstractDialogDc;
import net.sf.cuf.fw2.DialogDc;

/**
 * MultiSelectDc is the dialog component of a dialog.
 * It demonstrates the multiple selection mechanism.
 */
public class MultiSelectDc extends AbstractDialogDc implements DialogDc
{
    /** our presentation peer */
    private MultiSelectPc mPc;

    /** the builder that created our Pc and UI */
    private SwingXMLBuilder mBuilder;

    /**
     * This method is called by the parent dialog controller during
     * the initialisation phase of an application.<br>
     *
     * @param pParent our parent must implement AppEventSupport
     * @param pArgs variable argument list modeled as a key/value map, never null.
     */
    public void init(final Dc pParent, final Map<String, ? super Object> pArgs)
    {
        super.init(pParent, pArgs);

        // load our Pc and its UI
        InputStream in= Thread.currentThread().getContextClassLoader().getResourceAsStream(AppData.XML_APP_MULTI_NAME);
        Map         nonVisual= new HashMap();
        nonVisual.put("MultiSelectDc", this);
        mBuilder= SwingXMLBuilder.create(in, nonVisual);
        mPc= (MultiSelectPc)mBuilder.getNonVisualObject("MultiSelectPc");
        mPc.init(this, pArgs);
    }

    /**
     * Called from the dialog coordinator to tell the dialog to switch
     * to the active state.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void doActivate(final Map<String, ? super Object> pArgs)
    {
        System.out.println("MultiSelectDc.doActivate");
    }

    /**
     * Called from the dialog coordinator to tell the dialog to switch
     * to the passive state.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void doPassivate(final Map<String, ? super Object> pArgs)
    {
        System.out.println("MultiSelectDc.doPassivate");
    }

    /**
     * Called from the dialog coordinator to tell the dialog to cleanup all
     * resources. We only call dispose of our Pc.
     * @param pArgs arguments, key is a String, value is any suitable objekt for the key
     */
    public void dispose(final Map<String, ? super Object> pArgs)
    {
        mPc.dispose(pArgs);
    }

    /**
     * Called from the dialog coordinater in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    public Object getVisualPresentation()
    {
        return mPc.getVisualPresentation();
    }
}
