package net.sf.cuf.examples.state;

import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.AbstractSwingApplication;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.ui.SwingDecorator;
import net.sf.cuf.fw2.UserProperties;
import com.jgoodies.looks.Options;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

import javax.swing.UIManager;
import javax.swing.SwingUtilities;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.InputStream;
import java.io.IOException;
import java.util.Map;
import java.util.HashMap;

/**
 * This small application demonstrates the use of State and StateAdapter
 * objects. Most of the interesting stuff is in the init() method of
 * the StatePc class.
 */
public class Main extends AbstractSwingApplication implements Application
{
    /**
     * We have a private constructor so only main() can construct us.
     */
    private Main()
    {
        super();
    }

    public void doStart(final String[] pArgs)
    {
        super.doStart(pArgs);

        // load properties
        loadProperties();

        /*
         * The following tweaks were taken from
         * http://wiki.java.net/bin/view/Javadesktop/SecretSwingProperties and
         * http://www.javadesktop.org/forums/thread.jspa?threadID=7311&tstart=255
         */

        // relayout if component size changes
        Toolkit.getDefaultToolkit().setDynamicLayout(true);

        // do not erase the backgound during moving windows "gray fog"
        System.setProperty("sun.awt.noerasebackground", "true");

        // keep awt working set in memory (only relevant on Windows, needs Java 5.0)
        // for details see http://support.microsoft.com/default.aspx?scid=kb;en-us;293215
        // and http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5043070
        System.setProperty("sun.awt.keepWorkingSetOnMinimize", "true");

        // use anti-alias text on Linux
        if (System.getProperty("os.name", "unknown").toLowerCase().contains("linux"))
        {
            System.setProperty("swing.aatext", "true");
        }

        // init Look&Feel
        try
        {
            // check if the user set a specifc LAF from the command line
            String defaultLAF= System.getProperty("swing.defaultlaf");
            if (defaultLAF==null)
            {
                // jgoodies code start
                UIManager.put(Options.USE_SYSTEM_FONTS_APP_KEY, Boolean.TRUE);
                Options.setDefaultIconSize(new Dimension(18, 18));

                //defaultLAF= Options.getSystemLookAndFeelClassName();
                defaultLAF= Options.getCrossPlatformLookAndFeelClassName();
                // jgoodies code end
                //defaultLAF= UIManager.getSystemLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(defaultLAF);
        }
        catch (Exception ignored)
        {
        }

        // init SwingDecorator (only needed by SortingTable)
        SwingDecorator.addBundle("i18n/sortingtable");

        // load GUI and other objects
        String      fileName= AppData.XML_UI_NAME;
        ClassLoader loader  = getClass().getClassLoader();
        if (loader==null)
        {
            loader= ClassLoader.getSystemClassLoader();
        }
        InputStream     input  = loader.getResourceAsStream(fileName);
        SwingXMLBuilder builder= SwingXMLBuilder.create(input);

        // init Dc's/Pc's in the Swing's event dispatch thread (EDT)
        final Dc  dc  = (Dc) builder.getNonVisualObject("StateDc");
        final Map<String, Object> args= new HashMap<>();
        args.put(APPLICATION_KEY, this);
        SwingUtilities.invokeLater(() -> dc.init(null, args));

    }

    /**
     * Called to stop an application. Will call saveProperties() and
     * exits then.
     */
    public void doStop()
    {
        saveProperties();
        System.exit(0);
    }

    /**
     * Small helper to load the properties.
     */
    private void loadProperties()
    {
        try
        {
            mAppProperties = UserProperties.read(null, null, AppData.USER_PROPERTIES);
        }
        catch (IOException e)
        {
            System.err.println("loadProperties problems: " + e);
        }
    }

    /**
     * Save the application state to a persistence storage.
     */
    private void saveProperties()
    {
        try
        {
            UserProperties.write(mAppProperties, null, AppData.USER_PROPERTIES);
        }
        catch (IOException e)
        {
            System.err.println("saveProperties problems: " + e);
        }
    }

    /**
     * Main entry point to the application.
     * @param pArgs the arguments
     */
    public static void main(final String[] pArgs)
    {
        Application app= new Main();
        app.doStart(pArgs);
    }
}
