/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples.model.portal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.sf.cuf.examples.model.portal.ColorFactory;
import net.sf.cuf.examples.model.portal.CrossHairBorder;
import net.sf.cuf.examples.model.portal.PortalDc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw2.AbstractSwingAppPc;
import net.sf.cuf.fw2.AppPc;
import net.sf.cuf.fw2.DialogDescription;
import net.sf.cuf.ui.SwingConnectionManager;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class PortalPc
extends AbstractSwingAppPc
implements AppPc,
SwingXMLBuilder.Backlink {
    private SwingXMLBuilder mBuilder;
    private Application mApp;
    private PortalDc mDc;
    private JToggleButton mCurrentDialogButton;
    private boolean mInsideCB;

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        super.init(pDc, pArgs);
        this.mDc = (PortalDc)pDc;
        this.mApp = (Application)pArgs.get("Application");
        this.mStatusLabel = (JLabel)this.mBuilder.get("Frame/Panel/Status/StatusText");
        this.mToolBar = (JToolBar)this.mBuilder.get("Frame/Toolbar");
        this.mMenuBar = (JMenuBar)this.mBuilder.get("Frame/MenuBar");
        this.mMenuMap.put("/File", (JMenuItem)this.mBuilder.get("Frame/MenuBar/File"));
        this.mMenuMap.put("/Window", (JMenuItem)this.mBuilder.get("Frame/MenuBar/Window"));
        this.mToolBar.setPreferredSize(new Dimension(0, 40));
        GridBagConstraints buttonGBC = new GridBagConstraints();
        buttonGBC.gridx = 0;
        buttonGBC.fill = 1;
        buttonGBC.insets = new Insets(3, 4, 3, 4);
        JPanel useCasePanel = (JPanel)this.mBuilder.get("Frame/Panel/UCScrollPane/UCSelectPanel");
        useCasePanel.setBackground(ColorFactory.getControlShadow());
        useCasePanel.setLayout(new GridBagLayout());
        ButtonGroup buttonGroup = new ButtonGroup();
        Map knownDialogs = (Map)pArgs.get("knownDialogs");
        for (DialogDescription description : knownDialogs.values()) {
            ImageIcon icon = this.mBuilder.getIconCache().getIcon(description.getDialogIcon(), "");
            String text = description.getDialogName();
            JToggleButton button = new JToggleButton(text, icon);
            button.setName(description.getDialogId());
            button.setHorizontalTextPosition(0);
            button.setVerticalTextPosition(3);
            button.setFocusPainted(false);
            button.setOpaque(false);
            button.setBackground(ColorFactory.getControlShadow());
            button.setBorder(new CrossHairBorder());
            buttonGroup.add(button);
            SwingConnectionManager.createActionConnection((AbstractButton)button, (Object)((Object)this), (String)"ucSelected");
            buttonGBC.gridy = useCasePanel.getComponentCount();
            useCasePanel.add((Component)button, buttonGBC);
        }
        JPanel spacer = new JPanel();
        spacer.setName("Spacer");
        spacer.setOpaque(false);
        GridBagConstraints spacerGBC = new GridBagConstraints();
        spacerGBC.gridx = 0;
        spacerGBC.weightx = 1.0;
        spacerGBC.weighty = 1.0;
        spacerGBC.gridy = useCasePanel.getComponentCount();
        useCasePanel.add((Component)spacer, spacerGBC);
        JScrollPane scrollPane = (JScrollPane)this.mBuilder.get("Frame/Panel/UCScrollPane");
        scrollPane.setPreferredSize(new Dimension((int)scrollPane.getPreferredSize().getWidth() + 6, 0));
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        this.mFrameOrDialog = frame;
        int x = Integer.parseInt("40");
        int y = Integer.parseInt("30");
        int width = Integer.parseInt("600");
        int height = Integer.parseInt("600");
        try {
            x = Integer.parseInt(this.mApp.getProperty("windowsize.x", "40"));
            y = Integer.parseInt(this.mApp.getProperty("windowsize.y", "30"));
            width = Integer.parseInt(this.mApp.getProperty("windowsize.width", "600"));
            height = Integer.parseInt(this.mApp.getProperty("windowsize.height", "450"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        frame.setLocation(x, y);
        frame.setSize(width, height);
    }

    public void dispose(Map<String, ? super Object> pArgs) {
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        int width = frame.getWidth();
        int height = frame.getHeight();
        int x = frame.getX();
        int y = frame.getY();
        this.mApp.setProperty("windowsize.x", Integer.toString(x));
        this.mApp.setProperty("windowsize.y", Integer.toString(y));
        this.mApp.setProperty("windowsize.width", Integer.toString(width));
        this.mApp.setProperty("windowsize.height", Integer.toString(height));
        frame.dispose();
        SwingConnectionManager.removeConnection((Object)((Object)this));
        super.dispose(pArgs);
    }

    void showSubDialog(Object pVisualPresentation) {
        Component child = (Component)pVisualPresentation;
        JPanel ucPanel = (JPanel)this.mBuilder.get("Frame/Panel/SubDialogPanel");
        ucPanel.add(child);
        ucPanel.revalidate();
        ucPanel.repaint();
    }

    void hideSubDialog() {
        JPanel ucPanel = (JPanel)this.mBuilder.get("Frame/Panel/SubDialogPanel");
        ucPanel.removeAll();
        ucPanel.revalidate();
        ucPanel.repaint();
    }

    void show() {
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        frame.setVisible(true);
    }

    void hide() {
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        frame.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ucSelected(ActionEvent pEvent) {
        if (this.mInsideCB) {
            return;
        }
        this.mInsideCB = true;
        try {
            JToggleButton newDialogButton = (JToggleButton)pEvent.getSource();
            if (newDialogButton == this.mCurrentDialogButton) {
                return;
            }
            String newDialogId = newDialogButton.getName();
            boolean activated = this.mDc.activateDialog(newDialogId);
            if (!activated) {
                if (this.mCurrentDialogButton != null) {
                    this.mCurrentDialogButton.setSelected(true);
                }
            } else {
                this.mCurrentDialogButton = newDialogButton;
            }
        }
        finally {
            this.mInsideCB = false;
        }
    }
}

