/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;
import net.sf.cuf.ui.DispatcherAction;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class Split
implements SwingXMLBuilder.Backlink {
    private SwingXMLBuilder mBuilder;

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void init() {
        JTree tree = (JTree)this.mBuilder.getComponentByName("myFrame/SplitPane/NavigationScrollPane/Tree");
        tree.getSelectionModel().setSelectionMode(1);
        JTable table = (JTable)this.mBuilder.getComponentByName("myFrame/SplitPane/ContentPanel/TableScrollPane/Table");
        DefaultTableModel model = new DefaultTableModel(new Object[][]{{"Hallo", "Welt"}, {"Wie", "gehts?"}}, new Object[]{"Spalte1", "Spalte2"});
        table.setModel(model);
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("myFrame");
        frame.pack();
        frame.show();
    }

    public void quit(ActionEvent e) {
        System.out.println("quit");
        System.out.println("real source: " + ((DispatcherAction)e.getSource()).getRealSource());
        System.exit(0);
    }

    public void help(ActionEvent e) {
        System.out.println("help");
    }

    public void navSelection(TreeSelectionEvent e) {
        System.out.println("navigation changed:" + e);
        System.out.println("    old lead: " + e.getOldLeadSelectionPath());
        System.out.println("    new lead: " + e.getNewLeadSelectionPath());
        TreePath[] paths = e.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            if (e.isAddedPath(i)) {
                System.out.println("    path add: " + path);
                continue;
            }
            System.out.println("    path removed: " + path);
        }
    }

    public void tableSelection(ListSelectionEvent e) {
        System.out.println("Table selection changed: " + e);
    }

    public void about(ActionEvent e) {
        JDialog aboutDialog = (JDialog)this.mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.setModal(true);
        JButton okButton = (JButton)this.mBuilder.getComponentByName("myFrame/aboutDialog/Panel/OK");
        aboutDialog.getRootPane().setDefaultButton(okButton);
        aboutDialog.pack();
        Rectangle parentBounds = aboutDialog.getParent().getBounds();
        System.out.println("parent bounds:" + parentBounds);
        int deltaX = (parentBounds.width - aboutDialog.getBounds().width) / 2;
        int deltaY = (parentBounds.height - aboutDialog.getBounds().height) / 2;
        aboutDialog.setLocation(parentBounds.x + deltaX, parentBounds.y + deltaY);
        aboutDialog.show();
        System.out.println("after aboutDialog.show()");
    }

    public void aboutOk(ActionEvent e) {
        JDialog aboutDialog = (JDialog)this.mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.hide();
        System.out.println("about was OK!");
    }

    public void aboutCancel(ActionEvent e) {
        JDialog aboutDialog = (JDialog)this.mBuilder.getContainerByName("myFrame/aboutDialog");
        aboutDialog.hide();
        System.out.println("about was CANCELED!");
    }

    public static void main(String[] args) {
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("Split.xml");
        SwingXMLBuilder builder = SwingXMLBuilder.create((InputStream)input);
        Split pk = (Split)builder.getNonVisualObject("Pk");
        pk.init();
    }
}

