package net.sf.cuf.examples.model.portal;

import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import java.awt.Color;
import java.awt.SystemColor;

/**
 * The ColorFactory contains helper methods to access various colours that
 * depend on the current look&amp;feel.
 */
public class ColorFactory
{
    private static MetalLookAndFeel getMetalLookAndFeel()
    {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof MetalLookAndFeel)
        {
            return (MetalLookAndFeel)laf;
        }
        return null;
    }

    public static Color getControlShadow()
    {
        MetalLookAndFeel laf = getMetalLookAndFeel();
        if( laf != null )
        {
            return MetalLookAndFeel.getControlShadow();
        }
        return SystemColor.controlShadow;
    }

    public static Color getControl()
    {
        MetalLookAndFeel laf = getMetalLookAndFeel();
        if( laf != null )
        {
            return MetalLookAndFeel.getControl();
        }
        return SystemColor.control;
    }

    public static Color getControlDarkShadow()
    {
        MetalLookAndFeel laf = getMetalLookAndFeel();
        if( laf != null )
        {
            return MetalLookAndFeel.getControlDarkShadow();
        }
        return SystemColor.controlDkShadow;
    }
}
