package net.sf.cuf.examples.model.portal;

import net.sf.cuf.fw2.AbstractDialogDc;
import net.sf.cuf.fw2.DialogDc;
import net.sf.cuf.fw2.CloseDialogEvent;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;

import java.util.Map;

/**
 * This dialog is an example of a simple modal about dialog.
 */
public class AboutDc extends AbstractDialogDc implements DialogDc, SwingXMLBuilder.Backlink
{
    /** the builder that created us, never null after init */
    private SwingXMLBuilder mBuilder;
    /** our presentation peer, never null after init */
    private AboutPc         mPc;

    @Override
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    @Override
    public void init(Dc pParent, Map<String, ? super Object> pArgs)
    {
        super.init(pParent, pArgs);

        mPc= (AboutPc)mBuilder.getNonVisualObject("AboutPc");
        mPc.init(this, pArgs);
    }

    @Override
    public void doActivate(Map<String, ? super Object> pArgs)
    {
        mPc.show();
    }

    @Override
    public void doPassivate(Map<String, ? super Object> pArgs)
    {
        mPc.hide();
    }

    @Override
    public void dispose(Map<String, ? super Object> pArgs)
    {
        mPc.dispose(pArgs);
    }

    @Override
    public Object getVisualPresentation()
    {
        return mPc.getVisualPresentation();
    }

    /**
     * Close the dialog via a CloseDialogEvent(), this
     * will trigger a call to hide().
     */
    public void close()
    {
        CloseDialogEvent close= new CloseDialogEvent(this, this);
        postAppEvent(close);
    }
}
