package net.sf.cuf.examples.model.uc1;

import net.sf.cuf.xfer.AbstractRequest;
import net.sf.cuf.xfer.Response;
import net.sf.cuf.xfer.DefaultResponse;
import net.sf.cuf.xfer.RequestDelegate;
import net.sf.cuf.xfer.Request;

import java.util.List;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Date;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.text.DateFormat;

/**
 * This class simulates a server access by loading a List of data objects.
 * If the initial file is not available, the data is generated.
 * The file is never loaded if the delegate is used, this can be triggered from
 * the command line with
 *   java -Dnet.sf.cuf.examples.model.uc1.LoadDataRequest.delegate=&lt;some class implementing RequestDelegate&gt;
 */
public class LoadDataRequest extends AbstractRequest<List<UserData>> implements RequestDelegate<List<UserData>>
{
    private int mDummyDataCounter;

    public LoadDataRequest(final int pDummyDataCounter)
    {
        super();
        mDummyDataCounter= pDummyDataCounter;
    }

    /**
     * Generate a response for the current request state.
     * @return the response (must not be null)
     */
    public Response<List<UserData>> execute()
    {
        DefaultResponse<List<UserData>> back= new DefaultResponse<>();
        try
        {
            Properties p= new Properties();
            p.load(new FileInputStream("modeltest.data"));
            int n= Integer.parseInt(p.getProperty("list.length"));

            List<UserData> dummyData= new ArrayList<>();
            for (int i= 0; i< n; i++)
            {
                UserData userData= new UserData();
                userData.setFirstName (p.getProperty("FirstName."+i));
                userData.setLastName  (p.getProperty("LastName."+i));
                userData.setMiddleName(p.getProperty("MiddleName."+i));
                String     born      = p.getProperty("Born."+i);
                DateFormat dateParser= new SimpleDateFormat();
                userData.setBorn       ((born==null) ? new Date() : dateParser.parse(born));

                dummyData.add(userData);
            }
            back.setResult(dummyData);
        }
        catch (Exception e)
        {
            // use the dummy data
            System.out.println("Warning: could not load real data, using dummy data");
            System.out.println("    "+e);
            return execute(this);
        }

        // simulate a long running server access
        try
        {
            Thread.sleep(2000);
        }
        catch (InterruptedException ignored) { }

        return back;
    }

    /**
     * Generates a response for the handed request.
     * @param pRequest the request, never null
     * @return a response for the request
     */
    public Response<List<UserData>> execute(final Request<List<UserData>> pRequest)
    {
        DefaultResponse<List<UserData>> back= new DefaultResponse<>();

        List<UserData> dummyData= new ArrayList<>();
        for (int i= 0; i< 10; i++)
        {
            UserData userData= new UserData();
            userData.setFirstName ("Vorname"+   (i+mDummyDataCounter));
            userData.setLastName  ("Nachname"+  (i+mDummyDataCounter));
            userData.setMiddleName("Mittel"+    (i+mDummyDataCounter));
            userData.setBorn       (new Date());
            dummyData.add(userData);
        }
        back.setResult(dummyData);

        return back;
    }
}
