package net.sf.cuf.examples.model.uc3;

import net.sf.cuf.fw2.DialogPc;
import net.sf.cuf.fw2.AbstractDialogPc;
import net.sf.cuf.fw2.OpenDialogEvent;
import net.sf.cuf.ui.builder.SwingXMLBuilder;
import net.sf.cuf.fw.Dc;

import javax.swing.JTextField;
import java.util.Map;

/**
 * UseCase3Pc is the presentation component of a very simple dialog.
 * It demonstrates the "show modal dialog" mechanism.
 */
public class UseCase3Pc extends AbstractDialogPc implements DialogPc, SwingXMLBuilder.Backlink
{
    /** the builder that created us */
    private SwingXMLBuilder mBuilder;

    /**
     * Callback method for the Builder.
     * @param pBuilder the builder that created that object
     */
    public void setSwingXMLBuilder(final SwingXMLBuilder pBuilder)
    {
        mBuilder= pBuilder;
    }

    /**
     * This method is called by the dialog controller peer during
     * the initialisation phase of an application.<br>
     *
     * @param pDc our peer dialog controller, must implement AppEventSupport
     * @param pArgs variable argument list modeled as a key/value map,
     *              never null.
     */
    @Override
    public void init(final Dc pDc, final Map<String, ? super Object> pArgs)
    {
        super.init(pDc, pArgs);
    }

    /**
     * Called from the DialogDc peer in the initialized, active or passive
     * state to get the visual representation for this dialog.
     * @return an object that represents the visual representation of this dialog
     */
    public Object getVisualPresentation()
    {
        return mBuilder.getComponentByName("UC3");
    }


    /**
     * Show our modal dialog via an app event.
     */
    public void showModalDialog()
    {
        OpenDialogEvent openDialog= new OpenDialogEvent(this, "Dialog3Modal");
        postAppEvent(openDialog);

        Map<String, Object> results= openDialog.getDialogResults();

        // extract + show result
        JTextField resultTF= (JTextField)mBuilder.get("UC3/Text");
        if (results.containsKey(ModalDc.RESULT_KEY))
        {
            resultTF.setText((String)results.get(ModalDc.RESULT_KEY));
        }
        else
        {
            resultTF.setText("<Modaler Dialog wurde vom Benutzer abgebrochen>");
        }
    }

}
