/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cuf.examples.state;

import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import net.sf.cuf.examples.state.StateDc;
import net.sf.cuf.fw.Application;
import net.sf.cuf.fw.Dc;
import net.sf.cuf.fw.Pc;
import net.sf.cuf.state.State;
import net.sf.cuf.state.ui.SwingDocumentState;
import net.sf.cuf.state.ui.SwingEnabledAdapter;
import net.sf.cuf.state.ui.SwingJTableEnabledAdapter;
import net.sf.cuf.state.ui.SwingListSelectionState;
import net.sf.cuf.state.ui.SwingSelectedState;
import net.sf.cuf.ui.builder.SwingXMLBuilder;

public class StatePc
implements Pc,
SwingXMLBuilder.Backlink {
    private SwingXMLBuilder mBuilder;
    private StateDc mDc;
    private Application mApp;
    private SwingDocumentState mDocumentState;

    public void setSwingXMLBuilder(SwingXMLBuilder pBuilder) {
        this.mBuilder = pBuilder;
    }

    public void init(Dc pDc, Map<String, ? super Object> pArgs) {
        this.mDc = (StateDc)pDc;
        this.mApp = (Application)pArgs.get("Application");
        JTable table = (JTable)this.mBuilder.getComponentByName("Frame/Panel/ScrollPane/Table");
        DefaultTableModel model = new DefaultTableModel(new Object[][]{{"Hans", "Mainer"}, {"Erika", "Mustermann"}}, new Object[]{"Vorname", "Name"});
        table.setModel(model);
        JTextField textfield = (JTextField)this.mBuilder.getComponentByName("Frame/Panel/TextField");
        JLabel defaultLabel = (JLabel)this.mBuilder.getComponentByName("Frame/Panel/Default");
        String defaultText = "match";
        textfield.setText(defaultText);
        defaultLabel.setText(defaultText);
        this.mDocumentState = new SwingDocumentState((JTextComponent)textfield, defaultText);
        SwingJTableEnabledAdapter textfieldMatchAdapter = new SwingJTableEnabledAdapter((State)this.mDocumentState);
        textfieldMatchAdapter.add((Object)table);
        JCheckBox checkbox = (JCheckBox)this.mBuilder.getComponentByName("Frame/Panel/CheckBox");
        SwingListSelectionState tableSelectionState = new SwingListSelectionState(table);
        SwingEnabledAdapter tableSelectionAdapter = new SwingEnabledAdapter((State)tableSelectionState);
        tableSelectionAdapter.add((Object)checkbox, true);
        SwingSelectedState checkboxState = new SwingSelectedState(checkbox.getModel());
        SwingEnabledAdapter checkboxAdapter = new SwingEnabledAdapter((State)checkboxState);
        checkboxAdapter.add((Object)textfield);
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        int x = Integer.parseInt("40");
        int y = Integer.parseInt("30");
        int width = Integer.parseInt("600");
        int height = Integer.parseInt("600");
        try {
            x = Integer.parseInt(this.mApp.getProperty("windowsize.x", "40"));
            y = Integer.parseInt(this.mApp.getProperty("windowsize.y", "30"));
            width = Integer.parseInt(this.mApp.getProperty("windowsize.width", "600"));
            height = Integer.parseInt(this.mApp.getProperty("windowsize.height", "450"));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        frame.setLocation(x, y);
        frame.setSize(width, height);
        frame.show();
    }

    public void quit(ActionEvent pEvent) {
        JFrame frame = (JFrame)this.mBuilder.getContainerByName("Frame");
        int width = frame.getWidth();
        int height = frame.getHeight();
        int x = frame.getX();
        int y = frame.getY();
        this.mApp.setProperty("windowsize.x", Integer.toString(x));
        this.mApp.setProperty("windowsize.y", Integer.toString(y));
        this.mApp.setProperty("windowsize.width", Integer.toString(width));
        this.mApp.setProperty("windowsize.height", Integer.toString(height));
        this.mDc.quit();
    }

    public void changeDefault(ActionEvent pEvent) {
        JLabel defaultLabel = (JLabel)this.mBuilder.getComponentByName("Frame/Panel/Default");
        JTextField textfield = (JTextField)this.mBuilder.getComponentByName("Frame/Panel/TextField");
        String newDefaultText = textfield.getText();
        defaultLabel.setText(newDefaultText);
        this.mDocumentState.setCompareContent(newDefaultText);
    }
}

